/***
*stream.c - find a stream not in use
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines _getstream() - find a stream not in use
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <file2.h>
#include <internal.h>


/***
*FILE *_getstream() - find a stream not in use
*
*Purpose:
*   find a stream not in use and make it available to caller. _lastiob is
*   the last FILE address. intended for use inside library only
*
*Entry:
*   None.  Reads _iob.
*
*Exit:
*   returns a pointer to a free stream, or NULL if all are in use.  A
*   stream becomes allocated if the caller decided to use it by setting
*   any r, w, r/w mode.
*
*   Note:  Optimized the code to use a near pointer for the stream.  This
*   is especially helpful in large model.  However, the drawback is that we
*   need another temporary 'retval' so that when we return NULL, we return
*   0:0, not DS:0.
*
*   [Multi-thread note: If a free stream is found, it is returned in a
*   LOCKED state.  It is the caller's responsibility to unlock the stream.]
*
*Exceptions:
*
*******************************************************************************/

FILE *
_getstream ()
{
    REG1 FILE _NEAR_ *stream = _iob;
    REG2 FILE *retval = NULL;

    /* Get the iob[] scan lock */

    /* Loop through the _iob table looking for a free stream.*/
    for (; stream <= _lastiob; stream++) {


        if (!inuse(stream)) {
            stream->_flag = 0;
            stream->_cnt = 0;
            stream->_ptr = stream->_base = NULL;
            stream->_file = -1;
            retval = stream;
            goto done;
        }


    }

/* Common return. */

done:
    return(retval);
}
