/***
*tmpfile.c - create unique file name or file
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines tmpnam() and tmpfile().
*
*******************************************************************************/

#include <stdio.h>
#include <share.h>
#include <stdlib.h>
#include <register.h>
#include <file2.h>
#include <malloc.h>
#include <io.h>
#include <errno.h>
#include <internal.h>
#include <string.h>

    static char namebuf[L_tmpnam];  /* internal static buffer for tmpnam */


/***
*char *tmpnam(s) - generate temp file name
*
*Purpose:
*   Creates a file name that is unique in the directory specified by
*   P_tmpdir in stdio.h.
*
*Entry:
*   char *s - ptr to place to put temp name (if NULL, use static buffer)
*
*Exit:
*   returns pointer to constructed file name (s or address of static mem)
*   returns NULL if fails
*
*Exceptions:
*
*******************************************************************************/


char  *tmpnam( s )
REG1 char *s;
{


    REG2 char *ptmp;
    int olderrno;
    unsigned int first;

    /* use internal buffer if user didn't provide one */
    if (s == NULL)
    s = namebuf;

    /* construct base name */

    *s = '\0';
    strcat(s,P_tmpdir);

    ptmp = s+sizeof(P_tmpdir);  /* point to null terminator */

    /* See if temp dir is the root. */
    if  (*(ptmp-2) != '\\')
    strcat(s,"\\");     /* append '\' */
    else
    ptmp--;         /* adjust pointer */

    /* Loop until a non-existent filename is found */

    olderrno = errno;
    first = _tmpoff;

    do {
    _tmpoff = ( ++_tmpoff ? _tmpoff : 1 );
    if (_tmpoff == first)
        return(NULL);   /* wrapped _tmpoff - return error */
    _itoa( _tmpoff, ptmp, 10 );
    errno = 0;
    }
    while ( ( _access( s, 0 ) == 0 ) || ( errno == EACCES ) );

    errno = olderrno;   /* restore errno */
    return( s );
}


/***
*FILE *tmpfile() - create a temporary file
*
*Purpose:
*   Creates a temporary file with the file mode "w+b".  The file
*   will be automatically deleted when closed or the program terminates
*   normally.
*
*Entry:
*   None.
*
*Exit:
*   Returns stream pointer to opened file.
*   Returns NULL if fails
*
*Exceptions:
*
*******************************************************************************/

FILE *  tmpfile()
{
    _WINSTATIC char name[ L_tmpnam ];
    char *ptr;
    FILE *stream;
    int tmpnum;
    FILE *retval;

    /* Call tmpnam() to generate the filename.  Save the _tmpoff value. */

    ptr = name;
    ptr = tmpnam( ptr );
    tmpnum = _tmpoff;

    /* Now get a free stream and open the file. */
    /* [NOTE: _getstream() returns a locked stream.] */

    if ((stream = _getstream()) == NULL)
    return(NULL);

    retval = _openfile(name,"w+b",_SH_COMPAT,stream);

    if (retval != NULL)
    _tmpnum(stream) = tmpnum;   /* store _tmpoff value */

    /* unlock stream and return. */
    return(retval);
}
