/***
*vfprintf.c - fprintf from variable arg list
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines vfprintf() - print formatted output, but take args from
*   a stdargs pointer.
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <stdarg.h>
#include <file2.h>
#include <internal.h>
#include <dos.h>


/***
*int vfprintf(stream, format, ap) - print to file from varargs
*
*Purpose:
*   Performs formatted output to a file.  The arg list is a variable
*   argument list pointer.
*
*Entry:
*   FILE *stream - stream to write data to
*   char *format - format string containing data format
*   va_list ap - variable arg list pointer
*
*Exit:
*   returns number of correctly output characters
*   returns negative number if error occurred
*
*Exceptions:
*
*******************************************************************************/

int 
vfprintf (str, format, ap)
FILE *str;
const char *format;
va_list ap;
/*
 * 'V'ariable argument 'F'ile (stream) 'PRINT', 'F'ormatted
 */
{
    REG1 FILE _NEAR_ *stream;
    REG2 int buffing;
    REG3 int retval;

    assert(str != NULL);
    assert(format != NULL);

    /* Init stream pointer */
    stream = (FILE _NEAR_ *) FP_OFF(str);

    buffing = _stbuf(stream);
    retval = _output(stream,format,ap );
    _ftbuf(buffing, stream);

    return(retval);
}
