/***
*vprintf.c - printf from a var args pointer
*
*   Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   defines vprintf() - print formatted data from an argument list pointer
*
*******************************************************************************/

#include <stdio.h>
#include <register.h>
#include <assert.h>
#include <stdarg.h>
#include <internal.h>
#include <file2.h>


/***
*int vprintf(format, ap) - print formatted data from an argument list pointer
*
*Purpose:
*   Prints formatted data items to stdout.  Uses a pointer to a
*   variable length list of arguments instead of an argument list.
*
*Entry:
*   char *format - format string, describes data format to write
*   va_list ap - pointer to variable length arg list
*
*Exit:
*   returns number of characters written
*
*Exceptions:
*
*******************************************************************************/

int 
vprintf ( format, ap )
const char *format;
va_list ap;
/*
 * stdout 'V'ariable, 'PRINT', 'F'ormatted
 */
{
    REG1 FILE _NEAR_ *stream = stdout;
    REG2 int buffing;
    REG3 int retval;

    assert(format != NULL);

#ifdef  _QWIN
    /* If QWIN system is not used, stdout is not supported. */
    if (!_qwinused)
        return(EOF);
#endif

    buffing = _stbuf(stream);
    retval = _output(stream, format, ap );
    _ftbuf(buffing, stream);

    return(retval);
}
