	page	,132
	title	_cflush - flushall runtime termination
;***
;_cflush.asm - flushall runtime termination
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	definitions for flushall.
;
;*******************************************************************************

?DF	=	1		; tell cmacros.inc we want to define our own segments

include version.inc
.xlist
include cmacros.inc
include defsegs.inc
.list

;
; Segments
;

CrtDefSegs <code, data>
CrtDefSegs <xpseg>

codeOFFSET equ	offset _TEXT:
dataOFFSET equ	offset DGROUP:

page

;
; Data
;

sBegin	data
assumes ds,data

globalW _cflush,0		; resolve extern to pull this module in

externB _exitflag		; type of exit being performed

sEnd


ifndef _WINDLL

;
; Terminator
;

sBegin	xpseg

if	sizeC
	dd	_endstdio
else
	dw	_endstdio
endif

sEnd

;
; External Routines
;

externP _flushall
externP _fcloseall


sBegin	code
assumes cs,code

;***
; _endstdio - Terminate the stdio system
;
;Purpose:
;	Terminate the stdio system
;
;	(1) Flush all streams.	(Do this even if we're going to
;	call fcloseall since that routine won't do anything to the
;	std streams.)
;
;	(2) If returning to caller, close all streams.	This is
;	not necessary if the exe is terminating because the OS will
;	close the files for us (much more efficiently, too).
;
;Entry: <void>
;
;Exit:	<void>
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

cProc	_endstdio,<PUBLIC>,<>

cBegin <nolocals>


	call	_flushall	; flush all streams

	mov	al,[_exitflag]	; get exit flag
	or	al,al		; are we terminating (al == 0) ??
	jz	@F		; jump if so
	call	_fcloseall	; close all streams
@@:

done:

cEnd <nolocals>

sEnd

endif	;!_WINDLL

	end
