	page	,132
	title	_flsbuf - flush buffer and output character

;***
;_flsbuf.asm - flush buffer and output character.
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines _flsbuf() - flush a file buffer and output a character.
;	If no buffer, make one.
;
;*******************************************************************************
;
;--- C VERSION OF ROUTINE
;
; #include <stdio.h>
; #include <register.h>
; #include <file2.h>
; #include <assertm.h>
; #include <malloc.h>
; #include <msdos.h>
; #include <internal.h>
; #include <dos.h>
; #ifdef MTHREAD
; #include <os2dll.h>
; #endif
;
; int cdecl _LOAD_DS
; _flsbuf (ch, str)
; int ch;
; FILE *str;
; {
;     REG1 FILE _NEAR_ *stream;
;     FILE2 _NEAR_ *stream2;
;     REG2 int charcount;
;     REG3 int written;
;     int fh;
;
;     assert(str,"str==NULL");
;
;     /* Init file handle and pointers */
;     stream = (FILE _NEAR_ *) FP_OFF(str);
;     fh = fileno(stream);
;     stream2 = &(_iob2_(stream));
;
;     if (!inuse(stream) || stream->_flag & _IOSTRG) {
;	  stream->_flag |= _IOERR;
;	  return(-1);
;     }
;
;     if (stream->_flag & _IOREAD) {
;	  stream->_flag |= _IOERR;
;	  stream->_cnt = 0;
;	  return(-1);
;     }
;
;     stream->_flag |= _IOWRT;
;     stream->_flag &= ~_IOEOF;
;     written = charcount = stream->_cnt = 0;
;
;     /* Get a buffer for this stream, if necessary. */
;     if (!anybuf2(stream,stream2)) {
;
;	  /* Do NOT get a buffer if (1) stream is stdout/stderr, and
;	     (2) stream is NOT a tty.
;	     [If stdout/stderr is a tty, we do NOT set up single char buffering.
;	     This is so that later temporary buffering will not be thwarted
;	     by the _IONBF bit being set (see _stbuf/_ftbuf usage).]
;	  */
; #ifdef  OS2
;	  if (!( ((stream==stdout) || (stream==stderr))
; #else
;	  if (!( ((stream==stdout) || (stream==stderr) || (stream==stdprn))
; #endif
;		  && (isatty(fh)) ))
;
;		      _getbuf(stream);
;
;	  } /* end !anybuf() */
;
;     /* If big buffer is assigned to stream... */
;     if (bigbuf2(stream,stream2)) {
;	  assert(stream->_ptr - stream->_base >= 0, "inconsistent IOB fields");
;
;	  charcount = stream->_ptr - stream->_base;
;	  stream->_ptr = stream->_base + 1;
;	  stream->_cnt = stream2->_bufsiz - 1;
;
;	  if (charcount > 0)
;	      written = _write(fh, stream->_base, charcount);
;	  else
;	      if (_osfile[fh] & FAPPEND)
;		  _lseek(fh,0L,SEEK_END);
;
;	  *stream->_base = ch;
;	  }
;
;     /* Perform single character output (either _IONBF or no buffering) */
;     else {
;	  charcount = 1;
;	  written = _write(fh, &ch, charcount);
;	  }
;
;     /* See if the write() was successful. */
;     if (written != charcount) {
;	  stream->_flag |= _IOERR;
;	  return(-1);
;	  }
;
;     return(ch & 0xff);
; }
;
;
;--- END OF C VERSION
;
.xlist
include version.inc
include cmacros.inc
include msdos.inc
include fcntl.inc
include stdio.inc
.list

sBegin	data
	assumes ds,data

externW _iob				; stream array
externW _iob2				; stream2 array
externB _osfile 			; array of handle attributes

ifdef _WINDLL
ife sizeD
staticB  _dschar,0			; static char for write (small data)
endif
endif

ifdef _QWIN
externW _qwinused			; QWIN in use flag
endif

sEnd	data

externNP _getbuf			; buffer a stream
externP  _write 			; write to file handle
externP  _lseek 			; seek on file handle

sBegin	code
	assumes cs,code
	assumes ds,data

;***
;int _flsbuf(ch, stream) - flush buffer and output character.
;
;Purpose:
;	flush a buffer if this stream has one. if not, try to get one. put the
;	next output char (ch) into the buffer (or output it immediately if this
;	stream can't have a buffer). called only from putc. intended for use
;	only within library.
;
;	[NOTE 1: It is valid for this module to assign a value directly to
;	_flag2 instead of simply twiddling bits in the case where we are
;	initializing an i/o buffer.]
;
;	[NOTE 2: Multi-thread - It is assumed that the caller has aquired
;	the stream lock.]
;
;	[NOTE 3: The code depends on _iob[] and _iob2[] being near arrays of
;	the total size and element size.]
;
;Entry:
;	FILE *stream - stream to flish and write on
;	char ch - character to output.
;
;Exit:
;	returns -1 if FILE is actually a string, or if can't write ch to
;	unbuffered file, or if we flush a buffer but the number of chars
;	written doesn't agree with buffer size.  Otherwise returns ch.
;	all fields in FILE struct can be affected except _file.
;
;Uses:	ax, bx, cx, dx
;
;Exceptions:
;
;*******************************************************************************

cProc	_flsbuf,<PUBLIC>,<si,di>

	parmW	char
	parmDP	stream

cBegin

; Set:
;	si = stream (= _iob entry)
;	al = stream->_flag

	mov	si,word ptr [stream]
	mov	al,[si]._flag

;**
; Check that either _IOWRT or _IORW is set, and _IOSTRG is not set.

	test	al,_IOWRT OR _IORW
	jz	reterror
	test	al,_IOSTRG
	jnz	reterror

;**
; Set the _cnt field to 0. This isn't need in the case of a 'big' buffer and
; is overwritten in that case. However, it is needed in all other cases and
; this is the cheapest place to do it.

	mov	[si]._cnt,0		; reset _cnt field to 0

;**
; Check that _IOREAD is not set or, if it is, then so is _IOEOF. Note that
; _IOREAD and IOEOF both being set implies switching from read to write at
; end-of-file, which is allowed by ANSI. Note that resetting the _cnt and
; _ptr fields amounts to doing an fflush() on the stream in this case. Note
; also that the _cnt field has to be reset to 0 for the error path as well
; (i.e., _IOREAD set but _IOEOF not set) as well as the non-error path.

	test	al,_IOREAD
	jz	set_flag
	test	al,_IOEOF		; at end-of-file?
	jz	reterror		;   no, go do error return
	mov	cx,word ptr [si]._base	; reset _ptr field to _base field
	mov	word ptr [si]._ptr,cx
	and	al,NOT _IOREAD		; clear _IOREAD bit
	; fall thru

;**
; Set _IOWRT and clear _IOEOF

set_flag:
	or	al,_IOWRT
	and	al,NOT _IOEOF
	mov	[si]._flag,al

;**
; Set:
;	di = _iob2 entry (aka stream2)
;	bx = stream->_file (= file handle)

	mov	di,si
	sub	di,dataOFFSET _iob
	add	di,dataOFFSET _iob2	; di = stream2 corresponding to stream
	xor	bx,bx
	mov	bl,[si]._file		; bx = file handle for stream

;**
; Test the buffering flags and branch accordingly

	test	al,_IOMYBUF
	jnz	bigbuf
	test	al,_IONBF
	jnz	singlechar
	test	[di]._flag2,_IOYOURBUF
	jnz	bigbuf

;**
; No buffering is in place at all. Check to see if the stream is stdout,
; stderr or, in DOS only, stdprn. If it is and if it is attached to a device,
; go do single character output. Otherwise, go try to buffer it.

ifdef	_WINDLL

; No stdout/stderr support in win dll

	jmp	short dogetbuf	; try to get a buffer

else	;!_WINDLL

ifdef	_QWIN

; See if QWIN system in use
ifndef 	_BAT16
	cmp	[_qwinused],0	; QWIN in use?
	je	dogetbuf	; nope, no std i/o files
endif   ;_BAT16
endif	;_QWIN

	cmp	si,stdout
	je	testdev
	cmp	si,stderr

ifndef _WINDOWS
	je	testdev
	cmp	si,stdprn
endif

	jne	dogetbuf

testdev:
	test	byte ptr [bx + dataOFFSET _osfile],FDEV
	jz	dogetbuf
	; fall thru to singlechar

endif	;_WINDLL

;**
; Single character output (either _IONBF or no buffering at all).

singlechar:
	mov	cx,1

ifdef	_WINDLL
ife sizeD
	; can not pass an ss-relative offset in small data model
	mov	al,byte ptr [char]	; move character to dgroup
	mov	[_dschar],al
	lea	di,[_dschar]		; ds:di = address of char
else
	lea	di,[char]		; ss:di = address of char
endif
else	;!_WINDLL
	lea	di,[char]		; ss:di = address of char
endif	;_WINDLL

if sizeD
	push	cx			; push args
	push	ss
	push	di
	push	bx
else
	push	cx
	push	di
	push	bx
endif

	callcrt _write			; write(handle,&char,1)

if sizeD
	add	sp,8
else
	add	sp,6
endif

	mov	cx,1			; set cx = 1 = number of chars...
	jmp	short doret		; ...that should have been written

;**
; Set up a return of -1 to indicate that an error has occurred and jump
; to done.  Set the error flag on the stream.

reterror:

	mov	ax,-1			; return -1 to indicate error
	or	[si]._flag, _IOERR	; set error flag
	jmp	short done

;**
; The stream is unbuffered, try to buffer it. Then, check the buffering
; flags again and branch accordingly.

dogetbuf:

	push	bx			; save file handle

if sizeD
	push	ds
	push	si
else
	push	si
endif

	call	_getbuf 		; _getbuf(stream)

if sizeD
	add	sp,4			; clean off arg
else
	pop	bx			; clean off arg
endif

	pop	bx			; restore file handle

	test	[si]._flag,_IOMYBUF	; did we get a 'big' buffer?
	jz	singlechar		;   no, single char buffering
	; fall thru (we have a 'big' buffer)

;**
; The stream has a 'big' buffer. Empty it with a write().

bigbuf:
	mov	cx,word ptr [si]._ptr
	mov	dx,word ptr [si]._base
	sub	cx,dx			; cx = number of chars in stream buffer
	inc	dx
	mov	word ptr [si]._ptr,dx	; set _ptr to _base + 1
	mov	dx,[di]._bufsiz
	dec	dx
	mov	[si]._cnt,dx		; set _cnt to _bufsiz - 1

	jcxz	dolseek 		; no chars in buffer to write

	push	cx			; save count

if sizeD
	push	cx			; push args
	push	word ptr [si]._base + 2
	push	word ptr [si]._base
	push	bx
else
	push	cx			; push args
	push	word ptr [si]._base
	push	bx
endif

	callcrt _write			; _write(handle,stream->_base,cx)

if sizeD
	add	sp,8			; clean off args
else
	add	sp,6			; clean off args
endif

	pop	cx			; restore count

;**
; Place 'char' in the stream buffer

bufchar:

if sizeD
	les	di,[si]._base
	mov	dx,[char]
	mov	es:[di],dl
else
	mov	di,[si]._base
	mov	dx,[char]
	mov	[di],dl
endif

	; fall thru to doret

;**
; Test the results of the call to write() (i.e., compare ax and cx). If
; successful, return char. Otherwise, return -1.

doret:
	cmp	ax,cx
	jne	reterror
	xor	ax,ax
	mov	al,byte ptr [char]
	jmp	short done

;**
; There are no characters in the stream buffer. If the FAPPEND bit is set
; in the _osfile entry, position the file pointer at the end of the file.

dolseek:
	xor	ax,ax			; needed for both branchings below
	test	byte ptr [bx + dataOFFSET _osfile],FAPPEND
	jz	bufchar

	mov	cx,SEEK_END		; push args
	push	cx
	push	ax			; note that ax is 0
	push	ax
	push	bx

	callcrt _lseek			; _lseek(handle,0L,SEEK_END)

	add	sp,8
	xor	ax,ax
	mov	cx,ax			; set ax = cx = 0
	jmp	short bufchar

done:
cEnd	<nolocals>

sEnd	code

	end
