	page	,132
	title	_freebuf - release a stream buffer
;***
;_freebuf.asm - release a buffer from a stream
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	defines _freebuf() - release a buffer from a stream
;
;*******************************************************************************
;
; --- C VERSION OF ROUTINE
;
; #include <stdio.h>
; #include <register.h>
; #include <file2.h>
; #include <assertm.h>
; #include <internal.h>
; #include <stdlib.h>
;
; _freebuf (stream)
; REG1 FILE *stream;
; {
;     assert(stream,"stream==NULL");
;     assert(stream->_file >=0,"_file<0");
;     assert(stream->_file < _nfile-1,"_file>=_nfile");
;
;     if (inuse(stream) && mbuf(stream))
;     {
;	  free(stream->_base);
;	  stream->_flag &= ~_IOMYBUF;
;	  stream->_base = stream->_ptr = NULL;
;	  stream->_cnt = 0;
;     }
; }
;
; --- END OF C VERSION
;
.xlist
include version.inc
include cmacros.inc
include stdio.inc
.list


sBegin	data
	assumes ds,data

externW _iob				; stream array

sEnd	data


externP free				; free heap block


sBegin	code
	assumes cs,code
	assumes ds,data

;***
;void near _freebuf(stream) - release a buffer from a stream
;
;Purpose:
;	free a buffer if at all possible. free() the space if malloc'd by me.
;	forget about trying to free a user's buffer for him; it may be static
;	memory (not from malloc), so he has to take care of it. this function
;	is not intended for use outside the library.
;
;ifdef MTHREAD
;	Multi-thread notes:
;	_freebuf() does NOT get the stream lock; it is assumed that the
;	caller has already done this.
;endif
;
;Entry:
;	FILE *stream - stream to free buffer on
;
;Exit:
;	Buffer may be freed.
;	No return value.
;
;Exceptions:
;
;*******************************************************************************

cProc	_freebuf,<PUBLIC,NEAR>,<si>

	parmDP	stream

cBegin
	mov	si,word ptr [stream]
	mov	al,[si]._flag

;**
; Check that the stream is in use and has buffer that we can free.

	test	al,_IOREAD OR _IOWRT OR _IORW
	jz	done
	test	al,_IOMYBUF
	jz	done

if sizeD
	push	word ptr [si]._base + 2 ; push stream->_base
	push	word ptr [si]._base
else
	push	[si]._base		 ; push stream->_base
endif

	call	free			; free(stream->_base)

if sizeD
	add	sp,4			; clean off arg
else
	pop	cx			; clean off arg
endif

	and	[si]._flag,NOT _IOMYBUF
	xor	ax,ax

if sizeD
	mov	word ptr [si]._base,ax
	mov	word ptr [si]._base + 2,ax
	mov	word ptr [si]._ptr,ax
	mov	word ptr [si]._ptr + 2,ax
else
	mov	[si]._base,ax
	mov	[si]._ptr,ax
endif

	mov	[si]._cnt,ax

done:
cEnd	<nolocals>

sEnd	code
	end
