	page	,132
	title	getbuf - get a stream buffer
;***
;_getbuf.c - Get a stream buffer
;
;	Copyright (c) 1987-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	Allocate a buffer and init stream data bases.
;
;*******************************************************************************
;
; #include <stdio.h>
; #include <file2.h>
; #include <assertm.h>
; #include <malloc.h>
; #include <internal.h>
; #include <register.h>
; #include <dos.h>
;
;
; void near cdecl
;  _getbuf(str)
;
; FILE *str;
; {
; REG1 FILE _NEAR_ *stream;
; REG2 FILE2 _NEAR_ *stream2;
;
; assert(str,"str==NULL");
;
; /* force library pre-termination procedure */
; _cflush++;
;
; /* Init pointers */
; stream = (FILE _NEAR_ *) FP_OFF(str);
; stream2 = &(_iob2_(stream));
;
; /* Try to get a big buffer */
;
; if (stream->_base = malloc(BUFSIZ)) {
;
;     /* Got a big buffer */
;     stream->_flag |= _IOMYBUF;
;     stream2->_bufsiz = BUFSIZ;
;     }
;
; else {
;
;     /* Did NOT get a buffer - use single char buffering. */
;     stream->_flag |= _IONBF;
;     stream->_base = &(stream2->_charbuf);
;     stream2->_bufsiz = 1;
;     }
;
; stream->_ptr = stream->_base;
; stream->_cnt = 0;
;
; return;
; }
;
.xlist
include version.inc
include cmacros.inc
include stdio.inc
.list

sBegin	data
	assumes ds,data

externW _iob				; stream array
externW _iob2				; stream2 array
externW _cflush 			; force library pre-termination
					; procedure (i.e., force _cflush.obj
					; to be linked in)

sEnd	data

externP malloc				; heap allocation


sBegin	code
	assumes cs,code
	assumes ds,data

;***
;_getbuf() - Allocate a buffer and init stream data bases
;
;Purpose:
;	Allocates a buffer for a stream and inits the stream data bases.
;
;	[NOTE  1: This routine assumes the caller has already checked to make
;	sure the stream needs a buffer.
;
;	[NOTE 2: Multi-thread - Assumes caller has acquired stream lock, if
;	needed.]
;
;	[NOTE 3: The code now assumes that _iob[] and _iob2[] are near arrays
;	of the same element size.]
;
;Entry:
;	FILE *stream = stream to allocate a buffer for
;
;Exit:
;	void
;
;Exceptions:
;
;*******************************************************************************

cProc	_getbuf,<PUBLIC,NEAR>,<si>

	parmDP	stream

cBegin

	mov	si,word ptr [stream]

	mov	ax,BUFSIZ
	push	ax
	call	malloc			; malloc(BUFSIZ)
	pop	cx			; clean off arg

;**
; Set:
;	bx = _iob2 entry (aka stream2)
; Note that by doing it here/now, we don't have to save/restore bx or di.

	mov	bx,si
	sub	bx,dataOFFSET _iob
	add	bx,dataOFFSET _iob2

;**
; Now, check the return from malloc(). If it worked, installed the newly
; malloc-ed buffer. Otherwise, install single character buffering.

if sizeD
	or	dx,dx			; NULL return?
else
	or	ax,ax			; NULL return?
endif

	jz	singlechar		;   yes, install single char buffer

;**
; Set stream->_flag and stream2->_bufsiz fields. Then, branch to code
; to set other stream fields.

	or	[si]._flag,_IOMYBUF
	mov	[bx]._bufsiz,BUFSIZ
	jmp	short setfields

singlechar:
	or	[si]._flag,_IONBF
	mov	[bx]._bufsiz,1

if sizeD
	mov	dx,ds
endif

	lea	ax,[bx]._charbuf

;**
; Set the _ptr, _base and _cnt fields of stream. Note that, on entry, ax
; (dx:ax in large data models) is a pointer to new stream buffer.

setfields:

if sizeD
	mov	word ptr [si]._ptr + 2,dx
	mov	word ptr [si]._ptr,ax
	mov	word ptr [si]._base + 2,dx
	mov	word ptr [si]._base,ax
else
	mov	word ptr [si]._ptr,ax
	mov	word ptr [si]._base,ax
endif

	mov	word ptr [si]._cnt,0

done:
cEnd	<nolocals>

sEnd	code
	end
