	page	,132
	title	_sftbuf - temporary buffering initialization and flushing
;***
;_sftbuf.asm - temporary buffering initialization and flushing
;
;   Copyright (c) 1985-1992, Microsoft Corporation. All rights reserved.
;
;Purpose:
;	temporary buffering initialization and flushing. if stdout/err is
;	unbuffered, buffer it temporarily so that string is sent to kernel as a
;	batch of chars, not char-at-a-time. if appropriate, make buffering
;	permanent.
;
;	[NOTE 1: These routines assume that the temporary buffering is only
;	used for output.  In particular, note that _stbuf() sets _IOWRT.]
;
;	[NOTE 2: It is valid for this module to assign a value directly to
;	_flag2 instead of simply twiddling bits since we are initializing the
;	buffer data base.]
;
;******************************************************************************/
;
; #include <stdio.h>
; #include <register.h>
; #include <file2.h>
; #include <assertm.h>
; #include <internal.h>
; #include <dos.h>
; #include <malloc.h>
; #ifdef MTHREAD
; #include <os2dll.h>
; #endif
;
; #ifdef   OS2
; /* Buffer pointers for stdout and stderr */
; void *_stdbuf[2] = { NULL, NULL};
; #else
; /* Buffer pointers for stdout, stderr, and stdprn. */
; void *_stdbuf[3] = { NULL, NULL, NULL};
; #endif
;
;
; int
; _stbuf (str)
; FILE *str;
; {
;     REG1 FILE _NEAR_ *stream;
;     REG2 FILE2 _NEAR_ *stream2;
;     int index;
;
;     assert(str,"str==NULL");
;
;     /* Init near stream pointer */
;     stream = (FILE _NEAR_ *) FP_OFF(str);
;
;     _cflush++;  /* force library pre-termination procedure */
;
;     /* Make sure stream is stdout/stderr and init _stdbuf index */
;     if (stream == stdout)
;	  index = 0;
;     else if (stream == stderr)
;	  index = 1;
; #ifndef OS2
;     else if (stream == stdprn)
;	  index = 2;
; #endif
;     else
;	  return(0);
;
;     /* Init pointer to _iob2 entry. */
;     stream2 = &(_iob2_(stream));
;
;     /* Make sure the stream is not already buffered. */
;     if (anybuf2(stream,stream2))
;	  return(0);
;
;     /* Allocate a buffer for this stream if we haven't done so yet. */
;     if (_stdbuf[index] == NULL)
;	  if ( (_stdbuf[index]=malloc(BUFSIZ)) == NULL )
;	      return(0);      /* error */
;
;     /* Set up the buffer */
;     stream->_ptr = stream->_base = _stdbuf[index];
;     stream->_cnt = stream2->_bufsiz = BUFSIZ;
;     stream2->_flag2 = (_IOYOURBUF | _IOFLRTN);
;     stream->_flag |= _IOWRT;
;
;     return(1);
; }
;
;
; _ftbuf (flag, str)
; int flag;
; FILE *str;
; {
;     REG1 FILE _NEAR_ *stream;
;     REG2 FILE2 _NEAR_ *stream2;
;
;     assert(flag == 0 || flag == 1,"flag!={0,1}");
;
;     /* Init near stream pointers */
;     stream = (FILE _NEAR_ *) FP_OFF(str);
;     stream2 = &(_iob2_(stream));
;
;     if (flag) {
;
;	  if ( (stream2->_flag2 & _IOFLRTN)
;	       && (isatty(fileno(stream))) ) {
;
;	      /* Flush the stream and tear down temp buffering. */
;	      _flush(stream);
;	      stream2->_flag2 = 0;
;	      stream2->_bufsiz = 0;
;	      stream->_base = stream->_ptr = NULL;
;	      }
;
;	  /* Note: If we expand the functionality of the _IOFLRTN bit to
;	  include other streams, we may want to clear that bit here under
;	  an 'else' clause (i.e., clear bit in the case that we leave the
;	  buffer permanently assigned.	Given our current use of that bit,
;	  the extra code is not needed. */
;
;	  } /* end flag = 1 */
;
; #ifndef MTHREAD
; /* NOTE: Currently, writing to the same string at interrupt level does not
;    work in multi-thread programs. */
;
; /* The following code is needed if an interrupt occurs between calls
;    to _stbuf/_ftbuf and the interrupt handler also calls _stbuf/_ftbuf. */
;
;     else
;	  if ( (stream2->_flag2 & _IOFLRTN)
;		 && (isatty(fileno(stream))) )
;		  _flush(stream);
;
; #endif  /* MTHREAD */
;
; }
;

.xlist
include version.inc
include cmacros.inc
include stdio.inc
include msdos.inc
.list

sBegin	data
	assumes ds,data

externW _iob				; stream array
externW _iob2				; stream2 array
externB _osfile 			; array of handle attributes
externW _cflush 			; force library pre-termination
					; procedure (i.e., force _cflush.obj
					; to be linked in)
ifdef _QWIN
externW _qwinused			; QWIN in use flag
externW _nfile				; boundary between OS and QWIN handles
endif


; Define stdbuf[], the array of temporary buffer pointers. There is one
; pointer for each of the streams stdout, stdout and, for DOS only, stdprn.


if sizeD
stdbuf	dd	3 dup(0)
else
stdbuf	dw	3 dup(0)
endif


sEnd	data


externP malloc				; heap allocation
externNP _flush				; single stream, lock assumed, flush


; Define a constant for the size of a data pointer (in bytes)

if sizeD
DPSIZE	equ	4
else
DPSIZE	equ	2
endif


sBegin	code
	assumes cs,code
	assumes ds,data

;***
;int near _stbuf(stream) - set temp buffer on stdout, stdprn, stderr
;
;Purpose:
;	if stdout/stderr is still unbuffered, buffer it.
;	this function works intimately with _ftbuf, and accompanies it in
;	bracketing normally unbuffered output. these functions intended for
;	library use only.
;
;	Notes:
;
;	Multi-thread: It is assumed that the caller has already aquired the
;	stream lock.
;
;	Code depends on _iob[] and _iob2[] being near arrays of the same size
;	and element size.
;
;Entry:
;	FILE *stream - stream to temp buffer
;
;Exit:
;	returns 1 if buffer initialized, 0 if not
;	sets fields in stdout or stderr to indicate buffering
;
ifdef _WINDLL
;	Always return 0 under windll since there are NO std files.
endif
ifdef _QWIN
;	If a handle is not stdout/err but IS a window, we set the _IOFLRTN
;	bit so _ftbuf() will flush it.	We return 0 in this case.
endif
;
;Exceptions:
;
;*******************************************************************************

cProc	_stbuf,<PUBLIC,NEAR>,<si,di>

	parmDP	stream

cBegin

ifndef	_WINDLL 	; No standard files open by default in windows

ifdef	_QWIN
	cmp	[_qwinused],0		; QWIN in use?
	je	retzero 		; nope, no std i/o files

	; QWIN code path may need _iob2 entry earlier than other models
	mov	si,word ptr [stream]	; si = _iob entry
	mov	di,si
	sub	di,dataOFFSET _iob
	add	di,dataOFFSET _iob2	; di = _iob2 entry
else
	mov	si,word ptr [stream]
endif


;**
; Verify that stream is one of { stdout, stdin, stdprn } and set bx to
; the appropriate stdbuf[] entry.

	mov	bx,dataOFFSET stdbuf			; stdbuf[0]
	cmp	si,stdout
	je	getiob2
	mov	bx,dataOFFSET stdbuf + DPSIZE		; stdbuf[1]
	cmp	si,stderr
ifndef	_WINDOWS
	je	getiob2
	mov	bx,dataOFFSET stdbuf + 2 * DPSIZE	; stdbuf[2]
	cmp	si,stdprn
endif

ifdef _QWIN
	; if stderr, join std buffering code path
	je	getiob2

;
; Not stdout/err.  If the file is an QWIN window, set _IOFLRTN bit
; and return 1 so we flush the stream later.
;
	mov	al,byte ptr [_nfile]	; 1st QWIN handle
	cmp	[si]._file,al		; QWIN handle ??
	jb	retzero 		; nope, return

	or	[di]._flag2,_IOFLRTN	; set flush flag
	jmp	short retzero		; return
else
	jne	retzero 		; not stdout/err/prn
	; fall thru			; set up buffering
endif

;**
; Set:
;	di = _iob2 entry (aka stream2)

getiob2:

ifdef _QWIN
	; di already set up (see above)
else
	mov	di,si
	sub	di,dataOFFSET _iob
	add	di,dataOFFSET _iob2
endif

;**
; Check if the stream is buffered. If so, go return 0.

	test	[si]._flag,_IOMYBUF OR _IONBF
	jnz	retzero
	test	[di]._flag2,_IOYOURBUF
	jnz	retzero

;**
; Check if the special buffer has already been allocated (iff the stdbuf
; entry is non-NULL).

if sizeD
	mov	ax,word ptr [bx]
	mov	dx,word ptr [bx + 2]
	mov	cx,ax
	or	cx,dx			; NULL?
	jz	mallocbuf		;   yes, go malloc() a buffer
else
	mov	ax,[bx]
	or	ax,ax			; NULL?
	jz	mallocbuf		;   yes, go malloc() a buffer
endif

;**
; Install the buffer. That is, set the _ptr, _base, _cnt and _flag of
; the stream entry, and the _bufsiz and _flag2 fields of the stream2 entry.

installbuf:

if sizeD
	mov	word ptr [si]._base,ax
	mov	word ptr [si]._base + 2, dx
	mov	word ptr [si]._ptr,ax
	mov	word ptr [si]._ptr + 2, dx
else
	mov	[si]._base,ax
	mov	[si]._ptr,ax
endif

	mov	[si]._cnt,BUFSIZ
	mov	[di]._bufsiz,BUFSIZ
	or	[si]._flag,_IOWRT
	mov	[di]._flag2,_IOYOURBUF OR _IOFLRTN
	mov	ax,1
	jmp	short stdone

;**
; No buffer has been allocated yet so malloc() one.

mallocbuf:
	push	bx			; save stdbuf[] entry

	mov	ax,BUFSIZ
	push	ax			; push arg
	call	malloc			; malloc(BUFSIZ)
	pop	bx			; clean off arg

	pop	bx			; restore stdbuf[] entry

if sizeD
	or	dx,dx			; NULL return?
else
	or	ax,ax			; NULL return?
endif

	jz	retzero 		;   yea, verily, go fail

if sizeD
	mov	word ptr [bx],ax	; put buffer ptr in stdbuf[]
	mov	word ptr [bx + 2],dx
else
	mov	[bx],ax 		; put buffer ptr in stdbuf[]
endif

	jmp	short installbuf

endif	;!_WINDLL

retzero:
	xor	ax,ax

stdone:
cEnd	<nolocals>


;***
;void near _ftbuf(flag, stream) - take temp buffering off a stream
;
;Purpose:
;	If stdout/stderr is being buffered and it is a device, _flush and
;	dismantle the buffer. if it's not a device, leave the buffering on.
;	This function works intimately with _stbuf, and accompanies it in
;	bracketing normally unbuffered output. these functions intended for
;	library use only
;
;	Notes:
;
;	Multi-thread: It is assumed that the caller has already aquired the
;	stream lock.
;
;	Code depends on _iob[] and _iob2[] being near arrays of the same size
;	and element size.
;
ifdef _WINDLL
;	The 'flag' value is always 0 under windll since there are no std
;	files available (see _stbuf above).
endif
ifdef _QWIN
;	If the file is NOT stdout/err but IS a window, the 'flag' value
;	will be 1 and _IOFLRTN will be set.  In this case we want to
;	flush the stream and clear the flag but NOT change the buffering
;	arrangement.
endif
;
;Entry:
;	int flag     - a flag to tell whether to dismantle temp buffering on a
;		       stream
;	FILE *stream - the stream
;
;Exit:
;	no return value
;	sets fields in stdout/stderr
;
;Exceptions:
;
;*******************************************************************************

cProc	_ftbuf,<PUBLIC,NEAR>,<si,di>

	parmW	flag
	parmDP	stream

cBegin

;**
; Set
;	si = stream (= _iob entry)
;	di = _iob2 entry (aka stream2)

	mov	si,word ptr [stream]
	mov	di,si
	sub	di,dataOFFSET _iob
	add	di,dataOFFSET _iob2


;**
; First, check if the _IOFLRTN bit is set and the stream is a device.
; If so, _flush it.

	test	[di]._flag2,_IOFLRTN	; _IOFLRTN set?
	jz	ftdone			;   no, go return
	xor	bx,bx
	mov	bl,[si]._file		; is it a device?
	test	byte ptr [bx + dataOFFSET _osfile],FDEV
	jz	ftdone			;   no, go return

if sizeD
	push	ds			; push arg
	push	si
else
	push	si			; push arg
endif

	call    _flush			; _flush(stream)

if sizeD
	add	sp,4			; clean off arg
else
	pop	ax			; clean off arg
endif


ifndef	_WINDLL

;**
; Test flag argument. If nonzero, tear down the buffering.

	cmp	[flag],0		; flag nonzero?
	jz	ftdone			;   no, done! go return

	xor	ax,ax
	mov	[di]._flag2,al
	mov	[di]._bufsiz,ax

if sizeD
	mov	word ptr [si]._ptr,ax
	mov	word ptr [si]._ptr + 2,ax
	mov	word ptr [si]._base,ax
	mov	word ptr [si]._base + 2,ax
else
	mov	[si]._ptr,ax
	mov	[si]._base,ax
endif

endif	;!_WINDLL

ftdone:
cEnd	<nolocals>

sEnd	code
	end
