	page	,132
	title	memchr - Memory search for memory models with far data
;***
;hmemchr.asm - memory search for huge data (compact and large models)
;
;	Copyright (c) 1986-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	contains memchr() for huge pointers (compact and large models)
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

	extrn	__AHINCR:ABS

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char huge *memchr(buf, chr, cnt) - search huge memory buffer for a character
;
;Purpose:
;	Searches the first "cnt" bytes of the buffer "buf" for the
;	character "chr".  The buffer may cross a segment boundary.
;
;Entry:
;	char huge *buf - buffer to be searched
;	char chr - character to search for
;	unsigned cnt - length of the buffer
;
;Exit:
;	DX:AX = pointer to first occurrence of character "chr" in buffer "buf"
;	returns NULL if "chr" does not occur in "buf"
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemchr,<PUBLIC>,<>

else

cProc	memchr,<PUBLIC>,<>

endif

	parmD	buf
	parmB	chr
	parmW	cnt

cBegin
	push	di

	mov	cx,(cnt)
	jcxz	notfound	; return NULL if cnt == 0 ?

	les	di,(buf)

	mov	dx,di
	neg	dx		; number of bytes left in segment (65536-DI)
	jz	full_segment

	sub	dx,cx
	sbb	bx,bx
	and	dx,bx
	add	dx,cx		; DX = min(65536-DI, CX)

	xchg	dx,cx		; CX = number of bytes to scan in this segment
	sub	dx,cx		; DX = number of bytes to scan in next segment

full_segment:
	mov	al,(chr)

	repne	scasb		; scan as much of "buf" as fits in this segment
	je	found

	xchg	dx,cx
	jcxz	notfound	; buffer does not cross into next segment

	mov	dx,es
	add	dx,__AHINCR
	mov	es,dx

	repne	scasb		; scan for remaining bytes in next segment
	je	found
notfound:
	xor	ax,ax
	cwd
	jmp	short done	; return NULL
found:
	mov	dx,es
	lea	ax,[di-1]	; return address of matching byte
done:
	pop	di
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG

	end
