	page	,132
	title	memcmp - Huge model memory compare
;***
;hmemcmp.asm - Contains memcmp/_memicmp routine for far data models
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	memcmp compares a source memory area to a destination memory area.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

	extrn	__AHINCR:ABS

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;void huge * memcmp(void huge * buf1, void huge * buf2, unsigned count) -
;
;Purpose:
;	This routine compares [count] bytes from the source
;	memory area [buf2] to the destination memory area [buf1].
;	The memory areas may be huge pointers.
;
;Entry:
;	void huge * buf1 = pointer to destination memory area
;	void huge * buf2 = pointer to source memory area
;	unsigned int count = number of characters to move
;
;Exit:
;	returns 0 if the regions are equal, -1 if the first is less, else +1
;
;Uses:
;	BX, CX, DX, ES
;
;Exceptions:
;
;*******************************************************************************


ifdef	MODELINDEP

    ifdef CASE_INSENSITIVE
cProc	_fmemicmp,<PUBLIC>,<>
    else
cProc	_fmemcmp,<PUBLIC>,<>
    endif

else ;	MODELINDEP

     ifdef CASE_INSENSITIVE
cProc	_memicmp,<PUBLIC>,<>
     else
cProc	memcmp,<PUBLIC>,<>
     endif

endif ; MODELINDEP

	parmD	buf1
	parmD	buf2
	parmw	count

cBegin
	xor	ax,ax		; assume return value of zero (for empty compare)

	mov	cx,(count)
	jcxz	empty_comp	; if count == 0 then there is nothing to compare

	push	ds
	push	di
	push	si
;
; DS:SI and ES:DI are loaded this way so that the CARRY FLAG
; gets the right way by the REP CMPSB instruction below.
;
	lds	si,(buf1)	; DS:SI = buf1
	les	di,(buf2)	; ES:DI = buf2
;
;	While Count != 0 Do
;		If (Count + SI > 65536) OR (Count + DI > 65536) Then
;			Num = Min(65536-SI, 65536-DI)
;		Else
;			Num = Count
;		Compare "Num" Bytes from DS:SI to ES:DI (SI += Num, DI += Num)
;		Count -= Num
;		If Count == 0 Then
;			BREAK
;		If SI == 0 Then
;			DS += __AHINCR
;		If DI == 0 Then
;			ES += __AHINCR
;
next:
	mov	ax,cx
	dec	ax

	mov	dx,di
	not	dx		; AX = Count-1, DX = 65535-DI

	sub	ax,dx
	sbb	bx,bx
	and	ax,bx
	add	ax,dx		; AX = MIN(Count-1, 65535-DI)

	mov	dx,si
	not	dx		; DX = -SI

	sub	ax,dx
	sbb	bx,bx
	and	ax,bx
	add	ax,dx
	inc	ax		; AX = Num = MIN(Count,65536-SI,65536-DI)

	xchg	ax,cx
	sub	ax,cx		; Count -= Num

ifdef	CASE_INSENSITIVE

	xchg	ax, dx
l1:
	lodsb
	mov	ah,es:[di]
	cmp	ah,al
	jne	mapcase
l2:
	inc	di
	loop	l1
	xchg	ax, dx

else ;	CASE_INSENSITIVE

	repe	cmpsb
	jne	differ		; regions differ?

endif ; CASE_INSENSITIVE

	xchg	ax,cx		; AX = 0 (guaranteed since ZF is set)
	jcxz	done		; If Count == 0 Then BREAK

	or	si,si
	jnz	update
;
	mov	ax,ds
	add	ax,__AHINCR
	mov	ds,ax		; update DS if appropriate
update:
	or	di,di
	jnz	next
;
	mov	ax,es
	add	ax,__AHINCR
	mov	es,ax		; update ES if appropriate
	jmp	next

ifdef	CASE_INSENSITIVE

mapcase:
	sub	al,'A'
	cmp	al,26		; sets CY if original AL was in ['A'..'Z']
	sbb	bl,bl
	and	bl,'a'-'A'	; BL = 020h if original AL was in ['A'..'Z']
	add	al,bl
	add	al,'A'		; AL is now case mapped

	sub	ah,'A'
	cmp	ah,26		; sets CY if original AH was in ['A'..'Z']
	sbb	bl,bl
	and	bl,'a'-'A'	; BL = 020h if original AH was in ['A'..'Z']
	add	ah,bl
	add	ah,'A'		; AH is now case mapped

	cmp	al,ah		; cmp	byte ptr es:[di],ds:[si]
	je	l2

endif ; CASE_INSENSITIVE

;
; Memory buffers differ -- CY is set if buf1 < buf2
;
;	Set AX = -1 if CY=1 (buf1<buf2) or AX = +1 if CY=0 (buf1>buf2)
;
differ:
	sbb	ax,ax
	sbb	ax,-1
;
; Restore registers and return AX
;
done:
	pop	si
	pop	di
	pop	ds
empty_comp:

cEnd	nolocals

% sEnd	CODE_SEG

	end
