	page	,132
	title	memcpy - Huge model memory copy
;***
;hmemcpy.asm - Contains memcpy routine for far data models
;
;	Copyright (c) 1987-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	Memcpy copies a source memory area to a destination memory area.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

	extrn	__AHINCR:ABS

ifdef	MEM_MOVE
if	sizeC
	externP _aFahdiff
else
	externP _aNahdiff
endif
endif ; MEM_MOVE

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;void huge *memcpy(dst, src, count) - copy source string to destination
;
;Purpose:
;	This routine copies [count] bytes from the source
;	memory area [src] to the destination memory area [dst],
;	without checking for overlapping addresses.  Checks are made
;	for segment boundries, so huge data is OK.
;
;Entry:
;	unsigned int count = number of characters to move
;	void huge *src = pointer to source memory area
;	void huge *dst = pointer to destination memory area
;
;Exit:
;	Returns a huge pointer to the destination memory area in DX:AX
;
;Uses:
;	BX, CX, DX, ES
;
;Exceptions:
;
;*******************************************************************************

ifdef	MEM_MOVE

    ifdef MODELINDEP
cProc	_fmemmove,<PUBLIC>,<>
    else
cProc	memmove,<PUBLIC>,<>
    endif

else ;	MEM_MOVE

ifdef	MEM_CCPY

    ifdef MODELINDEP
cProc	_fmemccpy,<PUBLIC>,<>
    else
cProc	_memccpy,<PUBLIC>,<>
    endif

else ;	MEM_CCPY

    ifdef MODELINDEP
cProc	_fmemcpy,<PUBLIC>,<>
    else
cProc	memcpy,<PUBLIC>,<>
    endif


endif ; MEM_CCPY

endif ; MEM_MOVE

	parmD	dst
	parmD	src
ifdef	MEM_CCPY
	parmW	chr
endif
	parmW	count

cBegin
	mov	cx,count

	push	ds
	push	di
	push	si

ifdef	MEM_MOVE
	or	cx,cx
	jnz	not_empty
	jmp	done
not_empty:
else
	jcxz	done		; if count == 0 then there is nothing to copy
endif

	lds	si,(src)	; DS:SI = src
	les	di,(dst)	; ES:DI = dst

ifdef	MEM_MOVE

	push	ds
	push	si
	push	es
	push	di

if	sizeC
	call	_aFahdiff
else
	call	_aNahdiff
endif
	mov	cx,(count)

	or	dx,dx
	js	next

	sub	ax,cx
	sbb	dx,0
	jnc	next

	dec	cx

	add	si,cx
	jnc	cross1
;
	mov	ax,ds
	add	ax,__AHINCR
	mov	ds,ax		; advance DS
;
cross1:
	add	di,cx
	jnc	cross2
;
	mov	ax,es
	add	ax,__AHINCR
	mov	es,ax		; advance ES
cross2:
	inc	cx
;
;	DS:SI += Count
;	ES:DI += Count
;	While Count != 0 Do
;		Num = MIN(Count,SI,DI)
;		Reverse Copy "Num" Bytes from DS:SI to ES:DI
;			(SI -= Num, DI -= Num)
;		Count -= Num
;		If Count == 0 Then
;			BREAK
;		If SI == 0xFFFF Then
;			DS -= __AHINCR
;		If DI == 0xFFFF Then
;			ES -= __AHINCR
;
next_r:
	mov	ax,cx
	dec	ax

	sub	ax,di
	sbb	bx,bx
	and	ax,bx
	add	ax,di		; AX = MIN(Count-1, 65535-DI)

	sub	ax,si
	sbb	bx,bx
	and	ax,bx
	add	ax,si
	inc	ax		; AX = Num = MIN(Count,SI,DI)

	xchg	ax,cx
	sub	ax,cx		; Count -= Num

	std
	rep	movsb		; move the bytes
	cld

	xchg	ax,cx
	jcxz	done		; If Count == 0 Then BREAK

	cmp	si,-1
	jnz	update_r
;
	mov	ax,ds
	sub	ax,__AHINCR
	mov	ds,ax		; update DS if appropriate
update_r:
	cmp	di,-1
	jnz	next_r
;
	mov	ax,es
	sub	ax,__AHINCR
	mov	es,ax		; update ES if appropriate
	jmp	next_r

endif ; MEM_MOVE

;
;	While Count != 0 Do
;		If (Count + SI > 65536) OR (Count + DI > 65536) Then
;			Num = Min(65536-SI, 65536-DI)
;		Else
;			Num = Count
;		Copy "Num" Bytes from DS:SI to ES:DI (SI += Num, DI += Num)
;		Count -= Num
;		If Count == 0 Then
;			BREAK
;		If SI == 0 Then
;			DS += __AHINCR
;		If DI == 0 Then
;			ES += __AHINCR
;
next:
	mov	ax,cx
	dec	ax

	mov	dx,di
	not	dx		; AX = Count-1, DX = 65535-DI

	sub	ax,dx
	sbb	bx,bx
	and	ax,bx
	add	ax,dx		; AX = MIN(Count-1, 65535-DI)

	mov	dx,si
	not	dx		; DX = -SI

	sub	ax,dx
	sbb	bx,bx
	and	ax,bx
	add	ax,dx
	inc	ax		; AX = Num = MIN(Count,65536-SI,65536-DI)

	xchg	ax,cx
	sub	ax,cx		; Count -= Num

ifdef	MEM_CCPY

	xchg	ax,bx		; save other count
	mov	ah,byte ptr (chr)
L1:
	lodsb
	stosb
	cmp	ah,al
	je	L2
	loop	L1

	xchg	ax,bx		; restore other count

else ;	MEM_CCPY

	shr	cx,1
	rep	movsw
	adc	cx,cx
	rep	movsb		; move the bytes

endif ; MEM_CCPY

	xchg	ax,cx
	jcxz	done		; If Count == 0 Then BREAK

	or	si,si
	jnz	update
;
	mov	ax,ds
	add	ax,__AHINCR
	mov	ds,ax		; update DS if appropriate
update:
	or	di,di
	jnz	next
;
	mov	ax,es
	add	ax,__AHINCR
	mov	es,ax		; update ES if appropriate
	jmp	next

ifdef	MEM_CCPY

L2:	mov	dx,es
	mov	ax,di		; DX:AX points after character copied
	jmp	short restore

endif
;
; Restore registers and return "dst" (memcpy/memmove) or NULL (memccpy)
;
done:

ifdef	MEM_CCPY
	xor	ax,ax
	cwd
else
	mov	ax,word ptr (dst)
	mov	dx,word ptr (dst+2)
endif ; MEM_CCPY

restore:
	pop	si
	pop	di
	pop	ds

cEnd	nolocals

sEnd

	end
