	page	,132
	title	memset - set memory to a character (Huge model)
;***
;hmemset.asm - set memory to a character (far data models)
;
;	Copyright (c) 1986-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines memset() - set a buffer to one character, buffer
;	can cross segment boundries.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

	extrn	__AHINCR:ABS

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char huge *memset(dst, chr, cnt) - set number of bytes all to same character
;
;Purpose:
;	Fills a section of memory all with the same character.	The memory
;	section can cross segment boundries, so huge data is allowed.
;
;Entry:
;	char huge *dst - memory to be filled
;	char chr - character to fill with
;	unsigned cnt - length of memory to be filled
;
;Exit:
;	DX:AX = pointer to dst
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemset,<PUBLIC>,<>

else

cProc	memset,<PUBLIC>,<>

endif

	parmD	dst
	parmW	chr
	parmW	cnt

cBegin
	mov	cx,(cnt)
	jcxz	empty

	push	di
	les	di,(dst)

	mov	dx,di
	neg	dx		; number of bytes left in segment (65536-DI)
	jz	full_segment

	sub	dx,cx
	sbb	bx,bx
	and	dx,bx
	add	dx,cx		; DX = min(65536-DI, CX)

	xchg	dx,cx		; CX = number of bytes to store in this segment
	sub	dx,cx		; DX = number of bytes to store in next segment

full_segment:
	mov	ax,(chr)
	mov	ah,al		; load character/byte in AH/AL for stosw

	shr	cx,1
	rep	stosw
	adc	cx,cx
	rep	stosb

	xchg	dx,cx
	jcxz	done		; anything left to store in next segment?

	mov	bx,es
	add	bx,__AHINCR
	mov	es,bx		; advance to next segment

	shr	cx,1
	rep	stosw
	adc	cx,cx
	rep	stosb

done:
	pop	di
empty:
	mov	ax,word ptr (dst)
	mov	dx,word ptr (dst+2)

	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG

	end
