	page	,132
	title	memccpy - copy bytes until character found
;***
;memccpy.asm - copy bytes until a character is found
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines memccpy() - copies bytes until a specifed character
;	is found, or a maximum number of characters have been copied.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;char *_memccpy(dest, src, chr, count) - copy bytes until character found
;
;Purpose:
;	Copies bytes from src to dest until count bytes have been
;	copied, or up to and including the character chr, whichever
;	comes first.
;
;	Algorithm:
;	char *
;	_memccpy (dest, sorc, chr, count)
;	      char *dest, *sorc, chr;
;	      unsigned int count;
;	      {
;	      while (count && (*dest++ = *sorc++) != chr)
;		      count--;
;
;	      return(count ? dest : NULL);
;	      }
;
;Entry:
;	char *dest - pointer to memory to receive copy
;	char *src - source of bytes
;	char chr - character to stop copy at
;	int count - max number of bytes to copy
;
;Exit:
;	returns pointer to byte immediately after chr in dest;
;	returns NULL if chr was never found
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemccpy,<PUBLIC>,<>

else

cProc	_memccpy,<PUBLIC>,<>

endif

	parmdp	dest
	parmdp	sorc
	parmb	chr
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,dest 	; di=pointer to dest (es=segment part)
	lds	si,sorc 	; si=pointer to source (ds=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,dest 	; di=pointer to dest
	mov	si,sorc 	; si=pointer to source
endif

	mov	ah,chr		; byte to look for in ah
	mov	cx,count	; get the max byte count
	jcxz	retnull 	; don't do loop if nothing to move

lupe:
	lodsb			; get byte into al and kick si
	stosb			; store byte from al and kick di
	cmp	al,ah		; see if we just moved the byte
	je	toend		; end of string

	loop	lupe		; dec cx & jmp to lupe if nonzero
				; else drop out & return NULL
retnull:
	xor	di,di		; null pointer

if	sizeD
	mov	es,di		; null segment part too
endif

toend:
	mov	ax,di		; return value

if	sizeD
	mov	dx,es		; segment part of addr
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

sEnd
	end
