	page	,132
	title	memchr - search memory for a given character
;***
;memchr.asm - search block of memory for a given character
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines memchr() - search memory until a character is
;	found or a limit is reached.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;char *memchr(buf, chr, cnt) - search memory for given character.
;
;Purpose:
;	Searched at buf for the given character, stopping when chr is
;	first found or cnt bytes have been searched through.
;
;	Algorithm:
;	char *
;	memchr (buf, chr, cnt)
;		char *buf;
;		int chr;
;		unsigned cnt;
;	{
;		while (cnt && *buf++ != c)
;			cnt--;
;		return(cnt ? --buf : NULL);
;	}
;
;Entry:
;	char *buf - memory buffer to be searched
;	char chr - character to search for
;	unsigned cnt - max number of bytes to search
;
;Exit:
;	returns pointer to first occurence of chr in buf
;	returns NULL if chr not found in the first cnt bytes
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemchr,<PUBLIC>,<>

else

cProc	memchr,<PUBLIC>,<>

endif

	parmDP	buf
	parmB	chr
	parmW	cnt

cBegin
	xor	ax,ax		; return NULL if cnt == 0
if sizeD
	cwd			; DX is assumed to be zero below
endif
	mov	cx,(cnt)
	jcxz	empty

	mov	bx,di		; Preserve DI
if sizeD
	les	di,(buf)
else
	mov	ax,ds
	mov	es,ax
	mov	di,(buf)
endif
	mov	al,(chr)

	repne	scasb		; scan for byte
	mov	ax,0		; DX == 0 from above if SIZED
	jne	done		; not found -- return NULL

if sizeD
	mov	dx,es
endif
	lea	ax,[di-1]	; found - return address of matching byte
done:
	mov	di,bx		; Restore DI
empty:
	pop	bp
	ret
cEnd	<nogen>

sEnd

	end
