	page	,132
	title	memcmp - compare to blocks of memory
;***
;memcmp.asm - compare two blocks of memory
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines memcmp() - compare two memory blocks lexically and
;	find their order.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int memcmp(buf1, buf2, count) - compare memory for lexical order
;
;Purpose:
;	Compares count bytes of memory starting at buf1 and buf2
;	and find if equal or which one is first in lexical order.
;
;	Algorithm:
;	int
;	memcmp (buf1, buf2, count)
;		char *buf1, *buf2;
;		unsigned count;
;	{
;		if (!count)
;			return(0);
;		while (--count && *buf1 == *buf2)
;			{
;			buf1++;
;			buf2++;
;			}
;		return(*buf1 - *buf2);
;	}
;
;Entry:
;	char *buf1, *buf2 - pointers to memory sections to compare
;	unsigned count - length of sections to compare
;
;Exit:
;	returns -1 if buf1 < buf2
;	returns  0 if buf1 == buf2
;	returns +1 if buf1 > buf2
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemcmp,<PUBLIC>,<>

else

cProc	memcmp,<PUBLIC>,<>

endif

	parmDP	buf1
	parmDP	buf2
	parmW	count

cBegin
	mov	dx,di		; preserve SI and DI
	mov	bx,si
;
; DS:SI and ES:DI are loaded this way so that the CARRY FLAG
; gets the right way by the REP CMPSB instruction below.
;
if	sizeD
	push	ds		; preserve DS
	lds	si,(buf1)	; DS:SI = buf1
	les	di,(buf2)	; ES:DI = buf2
else
	mov	ax,ds
	mov	es,ax		; ES = DS = DGROUP
	mov	si,(buf1)	; DS:SI = buf1
	mov	di,(buf2)	; ES:DI = buf2
endif
	xor	ax,ax
	mov	cx,(count)
	jcxz	done

	repe	cmpsb		; compare while equal, at most "count" bytes
	je	done		; buf1 == buf2?  (AX = 0)
				;	buf1 < buf2	buf1 > buf2
	sbb	ax,ax		;	AX=-1, CY=1	AX=0, CY=0
	sbb	ax,-1		;	AX=-1		AX=1
done:

if	sizeD
	pop	ds		; restore DS
endif
	mov	si,bx		; restore SI and DI
	mov	di,dx

	pop	bp
	ret
cEnd	<nogen>

sEnd
	end
