	page	,132
	title	memicmp - compare blocks of memory, ignore case
;***
;memicmp.asm - compare memory, ignore case
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines memicmp() - compare two blocks of memory for lexical
;	order.	Case is ignored in the comparison.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code
	assumes cs,code
	assumes ds,data

page
;***
;int _memicmp(first, last, count) - compare two blocks of memory, ignore case
;
;Purpose:
;	Compares count bytes of the two blocks of memory stored at first
;	and last.  The characters are converted to lowercase before
;	comparing (not permanently), so case is ignored in the search.
;
;	Algorithm:
;	int
;	_memicmp (first, last, count)
;	      char *first, *last;
;	      unsigned count;
;	      {
;	      if (!count)
;		      return(0);
;	      while (--count && tolower(*first) == tolower(*last))
;		      {
;		      first++;
;		      last++;
;		      }
;	      return(tolower(*first) - tolower(*last));
;	      }
;
;Entry:
;	char *first, *last - memory buffers to compare
;	unsigned count - maximum length to compare
;
;Exit:
;	returns <0 if first < last
;	returns 0 if first == last
;	returns >0 if first > last
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemicmp,<PUBLIC>,<si,di>

else

cProc	_memicmp,<PUBLIC>,<si,di>

endif

	parmdp	first
	parmdp	last
	parmw	count

cBegin

if	sizeD
	push	ds		; save ds
	lds	si,first	; ds:si=pointer to first
	les	di,last 	; es:di=pointer to last
else
	mov	si,first	; si=pointer to first
	mov	di,last 	; di=pointer to last
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	cx,count
	jcxz	toend		; if count=0

	mov	bh,'A'
	mov	bl,'Z'
	mov	dh,'a'-'A'	; add to cap to make lower

lupe:
	mov	ah,[si] 	; *first

if	sizeD
	mov	al,es:[di]	; *last
else
	mov	al,[di] 	; *last
endif

	inc	si		; first++
	inc	di		; last++

	cmp	ah,bh		; 'A'
	jb	skip1

	cmp	ah,bl		; 'Z'
	ja	skip1

	add	ah,dh		; make lower case

skip1:
	cmp	al,bh		; 'A'
	jb	skip2

	cmp	al,bl		; 'Z'
	ja	skip2

	add	al,dh		; make lower case

skip2:
	cmp	ah,al		; characters different ??
	jne	differ

	loop	lupe
	jmp	short toend	; cx = 0, return 0

differ:
	mov	cx,-1		; assume last is bigger
	jb	short toend	; last is, in fact, bigger (return -1)
	neg	cx		; first is bigger (return 1)

toend:
	mov	ax,cx

if	sizeD
	pop	ds		; restore ds
endif

cEnd

sEnd
	end
