	page	,132
	title	memset - set sections of memory all to one byte
;***
;memset.asm - set a section of memory to all one byte
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	contains the memset() routine
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list

sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;char *memset(dst, val, count) - sets "count" bytes at "dst" to "val"
;
;Purpose:
;	Sets the first "count" bytes of the memory starting
;	at "dst" to the character value "val".
;
;	Algorithm:
;	char *
;	memset (dst, val, count)
;		char *dst;
;		char val;
;		unsigned int count;
;		{
;		char *start = dst;
;
;		while (count--)
;			*dst++ = val;
;		return(start);
;		}
;
;Entry:
;	char *dst - pointer to memory to fill with val
;	char val - value to put in dst bytes
;	int count - number of bytes of dst to fill
;
;Exit:
;	returns dst, with filled bytes
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fmemset,<PUBLIC>,<>

else

cProc	memset,<PUBLIC>,<>

endif

	parmDP	dst
	parmB	value
	parmW	count

cBegin
	mov	dx,di		; Preserve DI

if	sizeD
	les	di,dst		; ES:DI = dst
else
	mov	ax,ds
	mov	es,ax
	mov	di,dst		; ES:DI = dst
endif
	mov	bx,di		; save a copy of DST

	mov	cx,count
	jcxz	toend		; if no work to do

	mov	al,value	; the byte value to be stored
	mov	ah,al		; store it as a word

	test	di,1		; is dst address odd?
	jz	dowords 	;   yes: proceed

	stosb			;   no: store first byte to get word alignment
	dec	cx
dowords:
	shr	cx,1
	rep	stosw		; store word at a time
	adc	cx,cx
	rep	stosb		; store final ("odd") byte if necessary
toend:
	mov	di,dx		; Restore DI

	xchg	ax,bx		; AX = dst
if	sizeD
	mov	dx,es		; segment part of addr
endif
	pop	bp
	ret
cEnd	<nogen>

sEnd

	end
