	page	,132
	title	strcat - concatenate (append) one string to another
;***
;strcat.asm - contains strcat() routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation. All Rights Reserved.
;
;Purpose:
;	STRCAT concatenates (appends) a copy of the source string to the
;	end of the destination string, returning the destination string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strcat(dst, src) - concatenate (append) one string to another
;
;Purpose:
;	Concatenates src onto the end of dest.	Assumes enough
;	space in dest.
;
;	Algorithm:
;	char * strcat (char * dst, char * src)
;	{
;	    char * cp = dst;
;
;	    while( *cp )
;		    ++cp;	    /* Find end of dst */
;	    while( *cp++ = *src++ )
;		    ;		    /* Copy src to end of dst */
;	    return( dst );
;	}
;
;Entry:
;	char *dst - string to which "src" is to be appended
;	const char *src - string to be appended to the end of "dst"
;
;Exit:
;	The address of "dst" in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrcat,<PUBLIC>,<>

else

cProc	strcat,<PUBLIC>,<>

endif

	parmDP	dst
	parmDP	src

cBegin
	mov	dx,di		; Preserve SI and DI
	mov	bx,si

if	sizeD
	push	ds		; Preserve DS
	les	di,dst		; ES:DI = dst
else
	mov	ax,ds
	mov	es,ax
	mov	di,dst		; ES:DI = dst
endif
	xor	ax,ax
	mov	cx,-1		; find end of dst
	repne	scasb
	lea	si,[di-1]	; ES:SI = dst + strlen(dst)

if	sizeD
	les	di,src		; ES:DI = src
else
	mov	di,src		; ES:DI = src
endif
	mov	cx,-1		; compute strlen(src)
	repne	scasb
	not	cx		; CX = strlen(src) + 1

if	sizeD
	je	@F		; if final null reached, strlen < 0xffff
	sub	di,cx		; restore ES:DI = src (= ES:0 !)
	inc	cx		; CX = strlen(src) + 1 (= 0 !)
@@:
endif

	sub	di,cx		; restore ES:DI = src

if	sizeD
	mov	ax,es
	mov	ds,ax		; DS:DI = src
	mov	es,word ptr (dst+2)
endif
	xchg	di,si		; DS:SI = src, ES:DI = dst+strlen(dst)

	mov	ax,word ptr (dst)

if	sizeD
;
; Take care of the special case of src being exactly 0xffff in length
; (i.e., one full segment, counting the terminal null byte). This case is
; recognized here by CX being 0 (see above).
;
	or	cx,cx
	jnz	@F		; string is of 'normal' length
	movsw			; move two bytes
	dec	cx
	dec	cx		; 'tail' now has 'normal' length
	jmp	short move	; alignment check unnecessary, skip it.
@@:
endif

;
; There are 4 situations as far as word alignment of "src" and "dst":
;	1. src and dst are both even	(best case)
;	2. src is even and dst is odd
;	3. src is odd and dst is even
;	4. src and dst are both odd	(worst case)
;
; Case #4 is much faster if a single byte is copied before the
; REP MOVSW instruction.  Cases #2 and #3 are effectively unaffected
; by such an operation.  To maximum the speed of this operation,
; only DST is checked for alignment.  For cases #2 and #4, the first
; byte will be copied before the REP MOVSW.
;
	test	si,1		; fast check for src being odd address
	jz	move

	movsb			; move a byte to improve alignment
	dec	cx
;
; Now the bulk of the copy is done using REP MOVSW.  This is much
; faster than a REP MOVSB if the src and dst addresses are both
; word aligned and the processor has a 16-bit bus.  Depending on
; the initial alignment and the size of the region moved, there
; may be an extra byte left over to be moved.  This is handled
; by the REP MOVSB, which moves either 0 or 1 bytes.
;
move:
	shr	cx,1		; Shift CX for count of words
	rep	movsw		; CF set if one byte left over
	adc	cx,cx		; CX = 1 or 0, depending on Carry Flag
	rep	movsb		; possible final byte
;
; Return the "dst" address in AX/DX:AX
;
done:
	mov	si,bx
	mov	di,dx		; Restore SI and DI

if	sizeD
	pop	ds		;restore ds
	mov	dx,es		;segment part of dest address
endif
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
