	page	,132
	title	strchr - search string for given character
;***
;strchr.asm - search a string for a given character
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strchr() - search a string for a character
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strchr(string, c) - search a string for a character
;
;Purpose:
;	Searches a string for a given character, which may be the
;	null character '\0'.
;
;	Algorithm:
;	char *
;	strchr (string, ch)
;	      char *string, ch;
;	      {
;	      while (*string && *string != ch)
;		      string++;
;	      if (*string == ch)
;		      return(string);
;	      return((char *)0);
;	      }
;
;Entry:
;	char *string - string to search in
;	char c - character to search for
;
;Exit:
;	returns pointer to the first occurence of c in string
;	returns NULL if c does not occur in string
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrchr,<PUBLIC>,<>

else

cProc	strchr,<PUBLIC>,<>

endif

	parmdp	string
	parmb	chr

cBegin
	push	di

if	sizeD
	les	di,string	; di=pointer to string (es=segment part)
else
	mov	di,string	; di=pointer to string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	bx,di		; bx saves string pointer
	xor	ax,ax		; null byte to search for
	mov	cx,-1		; count bytes negatively in cx
repne	scasb			; find string length by scanning for null
	not	cx		; cx=strlen+1
	mov	al,chr		; al=byte to search for
	mov	di,bx		; restore from saved string pointer
repne	scasb			; find that byte (if it exists)!

;
; if the repne scasb above terminates with the zero flag set, a match has
; been found and di points to the byte FOLLOWING the matching byte. if
; the zero flag is NOT set and the character being scanned for was NOT
; a null ('\0'), then the scan has failed. in the remaining case, which
; can only occur in large data models, the string must be exactly 0x10000
; bytes long (counting the terminal null character) and the very last byte
; is the match.
;

	je	retsuccess	; have a match, go do the return

if	sizeD
	or	al,al		; were we looking for a null character?
	jnz	retfailure	; no, go return failure
	inc	di		; compensate for a decrement later on
	jmp	short retsuccess

retfailure:
endif

	xor	ax,ax		; no match, return NULL

if	sizeD
	xor	dx,dx
endif

	jmp	short toend

retsuccess:
	lea	ax,[di - 1]		; ret value: pointer to matching byte

if	sizeD
	mov	dx,es		; seg part
endif

toend:
	pop	di
cEnd

% sEnd	CODE_SEG
	end
