	page	,132
	title	strcmp.asm - compare two strings
;***
;strcmp.asm - routine to compare two strings (for equal, less, or greater)
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	STRCMP compares two strings and returns an integer
;	to indicate whether the first is less than the second, the two are
;	equal, or whether the first is greater than the second, respectively.
;	Comparison is done byte by byte on an UNSIGNED basis, which is to
;	say that Null (0) is less than any other character (1-255).
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;strcmp - compare two strings, returning less than, equal to, or greater than
;
;Purpose:
;	Compares two string, determining their lexical order.  Unsigned
;	comparison is used.
;
;	Algorithm:
;	   int strcmp ( src , dst )
;		   unsigned char *src;
;		   unsigned char *dst;
;	   {
;		   int ret = 0 ;
;
;		   while( ! (ret = *src - *dst) && *dst)
;			   ++src, ++dst;
;
;		   if ( ret < 0 )
;			   ret = -1 ;
;		   else if ( ret > 0 )
;			   ret = 1 ;
;
;		   return( ret );
;	   }
;
;Entry:
;	const char * src - string for left-hand side of comparison
;	const char * dst - string for right-hand side of comparison
;
;Exit:
;	AX < 0, 0, or >0, indicating whether the first string is
;	Less than, Equal to, or Greater than the second string.
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrcmp,<PUBLIC>,<>

else

cProc	strcmp,<PUBLIC>,<>

endif

	parmDP	src
	parmDP	dst

cBegin
	mov	dx,di		; preserve SI and DI
	mov	bx,si
if	sizeD
	push	ds		; preserve DS
	lds	si,src		; DS:SI = src
	les	di,dst		; ES:DI = dst
else
	mov	ax,ds
	mov	es,ax		; ES = DS = DGROUP
	mov	si,src		; DS:SI = src
	mov	di,dst		; ES:DI = dst
endif
	xor	ax,ax
	mov	cx,-1
	repne	scasb		; compute length of "dst"
	not	cx		; CX = strlen(dst)+1
	sub	di,cx		; restore ES:DI = dst
	repe	cmpsb		; compare while equal, at most length of "dst"
	je	toend		; dst == src?  (AX = 0)
				;	dst < src	dst > src
	sbb	ax,ax		;	AX=-1, CY=1	AX=0, CY=0
	sbb	ax,-1		;	AX=-1		AX=1
toend:

if	sizeD
	pop	ds		; restore DS
endif
	mov	si,bx		; restore SI and DI
	mov	di,dx

	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
