/***
*strcoll.c - Collate locale strings
*
*   Copyright (c) 1988-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Compare two strings using the locale LC_COLLATE information.
*
*******************************************************************************/

#include <string.h>



/***
*int strcoll() - Collate locale strings
*
*Purpose:
*   Compare two strings using the locale LC_COLLATE information.
*   [ANSI].
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*   Thus, strcoll() simply resolves to strcmp().
*Entry:
*   const char *s1 = pointer to the first string
*   const char *s2 = pointer to the second string
*
*Exit:
*   Less than 0    = first string less than second string
*   0          = strings are equal
*   Greater than 0 = first string greater than second string
*
*Exceptions:
*
*******************************************************************************/

int _cdecl  strcoll(_string1, _string2)
const char *_string1;
const char *_string2;
{
    return(strcmp(_string1,_string2));
}
