	page	,132
	title	strcpy - copy one string over another
;***
;strcpy.asm - contains strcpy() routine, copy strings
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All Rights Reserved
;
;Purpose:
;	STRCPY copies one string to another, overwriting the previous
;	contents of the destination string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strcpy(dst, src) - copy one string over another
;
;Purpose:
;	Copies the string src into the spot specified by
;	dest; assumes enough room.
;
;	Algorithm:
;	char * strcpy (char * dst, char * src)
;	{
;	    char * cp = dst;
;
;	    while( *cp++ = *src++ )
;		    ;		    /* Copy src over dst */
;	    return( dst );
;	}
;
;Entry:
;	char * dst - string over which "src" is to be copied
;	const char * src - string to be copied over "dst"
;
;Exit:
;	The address of "dst" in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrcpy,<PUBLIC>,<>

else

cProc	strcpy,<PUBLIC>,<>

endif
	parmDP	dst
	parmDP	src

cBegin
	mov	dx,di		; Preserve SI and DI
	mov	bx,si

if	sizeD
	push	ds		; Preserve DS
	lds	si,src		; DS:SI = src
else
	mov	si,src		; DS:SI = src
endif
	mov	di,si		; set ES:DI to DS:SI for first part
	mov	ax,ds
	mov	es,ax

	xor	ax,ax
	mov	cx,-1		; find length of src
	repne	scasb
	not	cx		; CX=strlen(src)+1

if	sizeD
	les	di,dst		; ES:DI = dst
else
	mov	di,dst		; ES:DI = dst
endif
	mov	ax,di		; AX = return value (offset)

if	sizeD
;
; Take care of special case of strlen = 0xffff (i.e., count the terminal
; null character, the string fills up a full segment). Note the zero flag
; has not been altered since the repne scasb and, therefore, will indicate
; whether or not the terminal null character was found.
;
	je	@F		; eos found, string is of normal length
	movsw			; move a word
	dec	cx		; now, tail of string has normal length and
				; CX = strlen(tail) + 1
	jmp	short move	; alignment check superfluous, skip it
@@:
endif

;
; There are 4 situations as far as word alignment of "src" and "dst":
;	1. src and dst are both even	(best case)
;	2. src is even and dst is odd
;	3. src is odd and dst is even
;	4. src and dst are both odd	(worst case)
;
; Case #4 is much faster if a single byte is copied before the
; REP MOVSW instruction.  Cases #2 and #3 are effectively unaffected
; by such an operation.  To maximum the speed of this operation,
; only DST is checked for alignment.  For cases #2 and #4, the first
; byte will be copied before the REP MOVSW.
;
	test	al,1		; fast check for dst being odd address
	jz	move

	movsb			; move a byte to improve alignment
	dec	cx
;
; Now the bulk of the copy is done using REP MOVSW.  This is much
; faster than a REP MOVSB if the src and dst addresses are both
; word aligned and the processor has a 16-bit bus.  Depending on
; the initial alignment and the size of the region moved, there
; may be an extra byte left over to be moved.  This is handled
; by the REP MOVSB, which moves either 0 or 1 bytes.
;
move:
	shr	cx,1		; Shift CX for count of words
	rep	movsw		; CF set if one byte left over
	adc	cx,cx		; CX = 1 or 0, depending on Carry Flag
	rep	movsb		; possible final byte
;
; Return the "dst" address in AX/DX:AX
;
done:
	mov	si,bx
	mov	di,dx		; Restore SI and DI

if	sizeD
	pop	ds		;restore ds
	mov	dx,es		;segment part of dest address
endif
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
