	page	,132
	title	strdup - duplicate string in malloc'd memory
;***
;strdup.asm - duplicate a string in malloc'd memory
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strdup() - grab new memory, and duplicate the string into it.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include model.inc
	.list

;
; stringDPTR = size of pointer that is supplied to the string routines.
; heapDPTR = size of pointer returned from heap call.
;
ifdef	MODELINDEP
    stringDPTR = 1
    ifdef   NEARMODELINDEP
	heapDPTR = 0
    else
	heapDPTR = 1
    endif
else
    stringDPTR = sizeD
    heapDPTR = sizeD
endif

;
; external routine declarations
;
ifdef	MODELINDEP
	externFP _fstrlen
	externFP _fstrcpy
else
	externP strlen
	externP strcpy
endif

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
	externP     _nmalloc
    else
	externP     _fmalloc
    endif

else ;	MODELINDEP

	externP malloc

endif ; MODELINDEP


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;char *_strdup(string) - duplicate string into malloc'd memory
;
;Purpose:
;	Allocates enough storage via malloc() for a copy of the
;	string, copies the string into the new memory, and returns
;	a pointer to it.
;
;	Algorithm:
;	char *_strdup (char *string)
;	{
;	      char *memory;
;
;	      if (!string)
;		      return(NULL);
;	      if (memory = malloc(strlen(string) + 1))
;		      return(strcpy(memory,string));
;	      return(NULL);
;	}
;
;Notes:
;	This source builds 3 objects:
;
;		(1) _strdup() - generic model version
;		(2) _fstrdup() - returns a far pointer
;		(3) _nstrdup() - returns a near pointer
;
;Entry:
;	char *string - string to copy into new memory
;
;Exit:
;	returns a pointer to the newly allocated storage with the
;	string in it.
;	returns NULL if enough memory could not be allocated, or
;	string was NULL.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
cProc	_nstrdup,<PUBLIC,FAR>,<>
    else
cProc	_fstrdup,<PUBLIC,FAR>,<>
    endif

	parmD	string

else ;	MODELINDEP

cProc	_strdup,<PUBLIC>,<>

	parmDP	string
endif


cBegin
	push	di		; save di

;
; calculate length
;

if	stringDPTR
	les	di,string	; di=pointer to string (es=segment part)
	push	es		; push segment part of address
else
	mov	di,string	; di=pointer to string
endif
	push	di		; stack parameter: string pointer

ifdef	MODELINDEP
	call	__fstrlen	; get it's length
else
	call	_strlen 	; get it's length
endif
				; ax = string length
	inc	ax		; need space for null byte too

if	stringDPTR
	jnz	@F		; string of normal length
				; string of maximum length, cannot dup!
if	heapDPTR
	xor	dx,dx
endif

	add	sp,4		; clean arg to strlen() off of stack
	jmp	short toend	; return NULL
@@:
endif

	push	ax		; stack parameter: string length (with null)

;
; get the space for duplicate string
; tos = length of string
; [source string pointer is still on stack, too]

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
	call	__nmalloc	; ax = near heap space
	mov	dx,ds		; dx:ax = far ptr to space (for _strcpy)
    else
	call	__fmalloc	; dx:ax = far heap space
    endif

else ;	MODELINDEP

	call	_malloc 	; (dx):ax = heap space

endif

	pop	bx		; burn malloc arg
				; (dx:)ax = heap pointer
if	heapDPTR
	mov	bx,ax		; preserve ax
	or	bx,dx		; dx:ax == NULL ??
	jnz	okay		; jump out if not
else
	or	ax,ax		; ax == NULL ??
	jnz	okay		; jump out if not
endif
	;fall thru		; error - return NULL

if	stringDPTR
	add	sp,4		; burn string arg still on stack
else
	pop	bx		; burn string arg still on stack
endif
	jmp	short toend	; error - return NULL

;
; copy source string to duplicate string
;

okay:

if	stringDPTR
	push	dx		; push segment part of dest string to copy to
endif
	push	ax		; stack pointer to dest

ifdef	MODELINDEP
	call	__fstrcpy
	add	sp,8		; always two far pointers
else
	call	_strcpy 	; duplicate the string
	add	sp,dat_addr_sz+dat_addr_sz ; burn 2 parameter pointers
endif

;
; Return pointer is in (dx:)ax	(may be NULL)
;

toend:
	pop	di

cEnd	<nolocals>

sEnd

	end
