	page	,132
	title	stricmp
;***
;strcmp.asm - contains case-insensitive string comparision routine stricmp/strcmpi
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	contains stricmpi(), also known as strcmpi()
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int _stricmp(dst, src), _strcmpi(dst, src) - compare strings, ignore case
;
;Purpose:
;	stricmp/strcmpi perform a case-insensitive string comparision.
;	For differences, upper case letters are mapped to lower case.
;	Thus, "abc_" < "ABCD" since "_" < "d".
;
;	Algorithm:
;
;	int _strcmpi (char * dst, char * src)
;	{
;		int f,l;
;
;		do {
;			f = tolower(*dst);
;			l = tolower(*src);
;			dst++;
;			src++;
;		} while (f && f == l);
;
;		return(f - l);
;	}
;
;Entry:
;	char *dst, *src - strings to compare
;
;Exit:
;	AX = -1 if dst < src
;	AX =  0 if dst = src
;	AX = +1 if dst > src
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

; alternate entry point for MS C 3.0 / 4.0 compatibility

ifndef	MODELINDEP

cProc	_strcmpi,<PUBLIC>,<>
cBegin	nogen
cEnd	nogen

endif

ifdef	MODELINDEP

cProc	_fstricmp,<PUBLIC>,<>

else

cProc	_stricmp,<PUBLIC>,<>

endif

	parmDP	dst
	parmDP	src

cBegin
	mov	dx,si		; preserve SI in DX

if	sizeD
	push	ds		; preserve DS
	lds	si,src		; DS:SI = src
	les	bx,dst		; ES:BX = dst
else
	mov	si,src		; SI = src
	mov	bx,dst		; BX = dst
endif
	mov	al,-1		; fall into loop

chk_null:
	or	al,al
	jz	done
again:
	lodsb
if	sizeD
	mov	ah,es:[bx]
else
	mov	ah,[bx]
endif
	inc	bx

	cmp	ah,al		; first try case-sensitive comparision
	je	chk_null	; match

	sub	al,'A'
	cmp	al,'Z'-'A'+1
	sbb	cl,cl
	and	cl,'a'-'A'
	add	al,cl
	add	al,'A'		; tolower(*dst)

	xchg	ah,al		; operations on AL are shorter than AH

	sub	al,'A'
	cmp	al,'Z'-'A'+1
	sbb	cl,cl
	and	cl,'a'-'A'
	add	al,cl
	add	al,'A'		; tolower(*src)

	cmp	al,ah		; inverse of above comparison -- AL & AH are swapped
	je	chk_null
				; dst < src	dst > src
	sbb	al,al		; AL=-1, CY=1	AL=0, CY=0
	sbb	al,-1		; AL=-1 	AL=1
done:
	cbw			; sign-extend AL to an int

if	sizeD
	pop	ds		; restore DS
endif
	mov	si,dx		; restore SI
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG

	end
