	page	,132
	title	strlen - return the length of a null-terminated string
;***
;strlen.asm - contains strlen() routine
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	strlen returns the length of a null-terminated string,
;	not including the null byte itself.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;strlen - return the length of a null-terminated string
;
;Purpose:
;	Finds the length in bytes of the given string, not including
;	the final null character.
;
;	Algorithm:
;	int strlen (const char * string)
;	{
;	    int length = 0;
;
;	    while( *string++ )
;		    ++length;
;
;	    return( length );
;	}
;
;Entry:
;	const char * string - string whose length is to be computed
;
;Exit:
;	AX = length of the string "string", exclusive of the final null byte
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrlen,<PUBLIC>,<>

else

cProc	strlen,<PUBLIC>,<>

endif

	parmDP	string

cBegin
	mov	dx,di		; Preserve DI

if	sizeD
	les	di,string	; ES:DI = string
else
	mov	ax,ds
	mov	es,ax
	mov	di,string	; ES:DI = string
endif
	xor	ax,ax		; null byte
	mov	cx,-1
	repne	scasb		; scan for null, CX = -(1+strlen(string))
	not	cx

if	sizeD
	jne	@F		; if didn't get to null, length must 0xffff
	dec	cx
@@:
else
	dec	cx
endif

	xchg	ax,cx		; AX = strlen(string)

	mov	di,dx		; Restore DI
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
