	page	,132
	title	strlwr - map string to lower-case
;***
;strlwr.asm - routine to map lower-case characters in a string to upper-case
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	STRLWR converts upper-case characters in a null-terminated string
;	to their lower-case equivalents.  Conversion is done in place and
;	characters other than upper-case letters are not modified.
;
;	This function modifies only 7-bit ASCII characters
;	in the range 0x41 through 0x5A ('A' through 'Z').
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *_strlwr(string) - map upper-case characters in a string to lower-case
;
;Purpose:
;	Converts all the upper case characters in a string to lower case,
;	in place.
;
;	Algorithm:
;	char * _strlwr (char * string)
;	{
;	    char * cp = string;
;
;	    while( *cp )
;	    {
;		if ('A' <= *cp && *cp <= 'Z')
;		    *cp += 'a' - 'A';
;		++cp;
;	    }
;	    return(string);
;	}
;
;Entry:
;	char *string - string to change to lower case
;
;Exit:
;	The input string address is returned in AX or DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrlwr,<PUBLIC>,<>

else

cProc	_strlwr,<PUBLIC>,<>

endif

	parmDP	string

cBegin
if	sizeD
	mov	cx,ds		; preserve DS
	lds	bx,string
else
	mov	bx,string
endif
	mov	dx,bx		; save return value
	jmp	short first_char; jump into loop

	even
check_char:
	sub	al,'A'		; 'A' <= al <= 'Z' ?
	cmp	al,'Z'-'A'+1
	jnb	next_char
	add	al,'a'		; map to lower case
	mov	[bx],al 	; and store new value
next_char:
	inc	bx		; bump string pointer
first_char:
	mov	al,[bx] 	; get next character
	or	al,al
	jnz	check_char

done:
	xchg	ax,dx		; AX = return value ("string")

if	sizeD
	mov	dx,ds		; DX:AX = return value ("string")
	mov	ds,cx		; restore DS
endif
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
