	page	,132
	title	strncat - append n chars of string1 to string2
;***
;strncat.asm - append n chars of string to new string
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strncat() - appends n characters of string onto
;	end of other string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strncat(front, back, count) - append count chars of back onto front
;
;Purpose:
;	Appends at most count characters of the string back onto the
;	end of front, and ALWAYS terminates with a null character.
;	If count is greater than the length of back, the length of back
;	is used instead.  (Unlike strncpy, this routine does not pad out
;	to count characters).
;
;	Algorithm:
;	char *
;	strncat (front, back, count)
;		char *front, *back;
;		unsigned count;
;	{
;		char *start = front;
;
;		while (*front++)
;			;
;		front--;
;		while (count--)
;			if (!(*front++ = *back++))
;				return(start);
;		*front = '\0';
;		return(start);
;	}
;
;Entry:
;	char *front - string to append onto
;	char *back - string to append
;	unsigned count - count of max characters to append
;
;Exit:
;	returns a pointer to string appended onto (front).
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrncat,<PUBLIC>,<>

else

cProc	strncat,<PUBLIC>,<>

endif

	parmDP	front
	parmDP	back
	parmW	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,front	; di=pointer to dest (es=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,front	; di=pointer to dest
endif

	mov	dx,di		; save return value in dx
	xor	ax,ax		; search value: null byte (assumed zero below!)
	mov	cx,-1		; so won't stop scan
repne	scasb			; find null byte
	dec	di		; di points to dest null terminator
	mov	bx,di		; bx   "    "	"    "	     "

if	sizeD
	push	es		; save dest seg pointer
	les	di,back 	; di=pointer to source (es=segment part)
else
	mov	di,back 	; di=pointer to source
endif

	mov	si,di		; si=pointer to source (used later)
	mov	cx,count	; count bytes negatively
repne	scasb			; find null byte & get source length
	jne	nonull
	inc	cx		; do NOT count null byte in length
nonull:
				; cx=count of difference in bytes in source
				;    with reference (without null)
	sub	cx,(count)	; take the difference of bytes counted to expected
	neg	cx		; away from expected
	mov	di,bx		; di=pointer to dest null terminator
				; si=pointer to source

if	sizeD
	push	es		; ds points to back
	pop	ds
	pop	es		; restore dest seg pointer
endif

rep	movsb			; concatenate the strings
				; WARNING: AL must be zero at this point!
	stosb			; attach null byte
	xchg	ax,dx		; (mov ax,dx) return value: dest addr

if	sizeD
	mov	dx,es		; segment part of addr
	pop	ds		; restore ds
endif
	pop	si
	pop	di
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG

	end
