	page	,132
	title	strncmp - compare first n chars of two strings
;***
;strncmp.asm - compare first n characters of two strings
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strncmp() - compare first n characters of two strings
;	for lexical order.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int strncmp(first, last, count) - compare first count chars of strings
;
;Purpose:
;	Compares two strings for lexical order.  The comparison stops
;	after: (1) a difference between the strings is found, (2) the end
;	of the strings is reached, or (3) count characters have been
;	compared.
;
;	Algorithm:
;	int
;	strncmp (first, last, count)
;	      char *first, *last;
;	      unsigned count;
;	      {
;	      if (!count)
;		      return(0);
;	      while (--count && *first && *first == *last)
;		      {
;		      first++;
;		      last++;
;		      }
;	      return(*first - *last);
;	      }
;
;Entry:
;	char *first, *last - strings to compare
;	unsigned count - maximum number of characters to compare
;
;Exit:
;	returns <0 if first < last
;	returns 0 if first == last
;	returns >0 if first > last
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrncmp,<PUBLIC>,<>

else

cProc	strncmp,<PUBLIC>,<>

endif

	parmdp	first
	parmdp	last
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
else
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	cx,count	; cx=max number of bytes to compare
	jcxz	toend		; it's as if strings are equal

	mov	bx,cx		; bx saves count

if	sizeD
	les	di,first	; di=first pointer (es=segment part)
else
	mov	di,first	; di=first pointer
endif

	mov	si,di		; si saves first pointer
	xor	ax,ax		; ax=0
repne	scasb			; count bytes
	neg	cx		; cx=count - strlen
	add	cx,bx		; strlen + count - strlen

okay:
	mov	di,si		; restore first pointer

if	sizeD
	lds	si,last 	; si=last pointer (ds=segment part)
else
	mov	si,last 	; si=last pointer
endif

repe	cmpsb			; compare strings
	mov	al,[si-1]
	xor	cx,cx

if	sizeD
	cmp	al,es:[di-1]	; last-first
else
	cmp	al,[di-1]	; last-first
endif

	ja	lastbig

	je	toend

firstbig:
	dec	cx		; first string is bigger
	dec	cx		; make FFFE so 'not' will give 0001

lastbig:			; last string is bigger
	not	cx		; return -1

toend:
	mov	ax,cx		; return value

if	sizeD
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
