	page	,132
	title	strncpy - copy at most n characters of string
;***
;strncpy.asm - copy at most n characters of string
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strncpy() - copy at most n characters of string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strncpy(dest, source, count) - copy at most n characters
;
;Purpose:
;	Copies count characters from the source string to the
;	destination.  If count is less than the length of source,
;	NO NULL CHARACTER is put onto the end of the copied string.
;	If count is greater than the length of sources, dest is padded
;	with null characters to length count.
;
;	Algorithm:
;	char *
;	strncpy (dest, source, count)
;	      char *dest, *source;
;	      unsigned count;
;	      {
;	      char *start = dest;
;
;	      while (count && (*dest++ = *source++))
;		      count--;
;	      if (count)
;		      while (--count)
;			      *dest++ = '\0';
;	      return(start);
;	      }
;
;Entry:
;	char *dest - pointer to spot to copy source, enough space
;	is assumed.
;	char *source - source string for copy
;	unsigned count - characters to copy
;
;Exit:
;	returns dest, with the character copied there.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrncpy,<PUBLIC>,<>

else

cProc	strncpy,<PUBLIC>,<>

endif

	parmdp	dest
	parmdp	sorc
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,dest 	; di=pointer to dest (es=segment part)
	lds	si,sorc 	; si=pointer to source (ds=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,dest 	; di=pointer to dest
	mov	si,sorc 	; si=pointer to source
endif
	mov	bx,di		; bx saves dest pointer
	mov	cx,count	; get the max char count
	jcxz	toend		; don't do loop if nothing to move

lupe:
	lodsb			; get byte into al and kick si
	or	al,al		; see if we just moved a null
	jz	outlupe 	; end of string

	stosb			; store byte from al and kick di
	loop	lupe		; dec cx & jmp to lupe if nonzero
				; else drop out
outlupe:
	xor	al,al		; null byte to store
rep	stosb			; store null for all cx>0

toend:
	mov	ax,bx		; return value: dest addr

if	sizeD
	mov	dx,es		; segment part of addr
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
