	page	,132
	title	strnicmp - compare n chars of strings, ignore case
;***
;strnicmp.asm - compare n chars of strings, ignoring case
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strnicmp() - Compares at most n characters of two strings,
;	without regard to case.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int _strnicmp(first, last, count) - compares count char of strings, ignore case
;
;Purpose:
;	Compare the two strings for lexical order.  Stops the comparison
;	when the following occurs: (1) strings differ, (2) the end of the
;	strings is reached, or (3) count characters have been compared.
;	For the purposes of the comparison, upper case characters are
;	converted to lower case.
;
;	Algorithm:
;	int
;	_strnicmp (first, last, count)
;	      char *first, *last;
;	      unsigned int count;
;	      {
;	      int f,l;
;	      int result = 0;
;
;	      if (count) {
;		      do      {
;			      f = tolower(*first);
;			      l = tolower(*last);
;			      first++;
;			      last++;
;			      } while (--count && f && l && f == l);
;		      result = f - l;
;		      }
;	      return(result);
;	      }
;
;Entry:
;	char *first, *last - strings to compare
;	unsigned count - maximum number of characters to compare
;
;Exit:
;	returns <0 if first < last
;	returns 0 if first == last
;	returns >0 if first > last
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

; alt entry for ANSI compatibility
ifdef	MODELINDEP

cProc	_fstrnicmp,<PUBLIC>,<>

else

cProc	_strnicmp,<PUBLIC>,<>

endif
	parmdp	first
	parmdp	last
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	lds	si,first	; ds:si=pointer to first
	les	di,last 	; es:di=pointer to last
else
	mov	si,first	; si=pointer to first
	mov	di,last 	; di=pointer to last
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	cx,count
	jcxz	toend		; if count=0

	mov	bh,'A'
	mov	bl,'Z'
	mov	dh,'a'-'A'	; add to cap to make lower

lupe:
	mov	ah,[si] 	; *first

if	sizeD
	mov	al,es:[di]	; *last
else
	mov	al,[di] 	; *last
endif

	or	ah,ah		; see if *first is null
	jz	eject		;   jump if so

	or	al,al		; see if *last is null
	jz	eject		;   jump if so

	inc	si		; first++
	inc	di		; last++

	cmp	ah,bh		; 'A'
	jb	skip1

	cmp	ah,bl		; 'Z'
	ja	skip1

	add	ah,dh		; make lower case

skip1:
	cmp	al,bh		; 'A'
	jb	skip2

	cmp	al,bl		; 'Z'
	ja	skip2

	add	al,dh		; make lower case

skip2:
	cmp	ah,al
	jne	differ

	loop	lupe

eject:
	xor	cx,cx
	cmp	ah,al		; compare the (possibly) differing bytes
	je	toend		; both zero; return 0

differ:
	mov	cx,0000h
	jb	lastbig

firstbig:
	dec	cx		; first string bigger
	dec	cx		; make FFFE so 'not' gives 0001

lastbig:
	not	cx

toend:
	mov	ax,cx

if	sizeD
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
