	page	,132
	title	strnset - set first n characters to one char.
;***
;strnset.asm - set first n characters to single character
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strnset() - sets at most the first n characters of a string
;	to a given character.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *_strnset(string, val, count) - set at most count characters to val
;
;Purpose:
;	Sets the first count characters of string the character value.
;	If the length of string is less than count, the length of
;	string is used in place of n.
;
;	Algorithm:
;	char *
;	_strnset (string, val, count)
;	      char *string,val;
;	      unsigned int count;
;	      {
;	      char *start = string;
;
;	      while (count-- && *string)
;		      *string++ = val;
;	      return(start);
;	      }
;
;Entry:
;	char *string - string to set characters in
;	char val - character to fill with
;	unsigned count - count of characters to fill
;
;Exit:
;	returns string, now filled with count copies of val.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrnset,<PUBLIC>,<>

else

cProc	_strnset,<PUBLIC>,<>

endif

	parmdp	string
	parmb	val
	parmw	count

cBegin
	push	di

if	sizeD
	les	di,string	; di=pointer to string (es=segment part)
else
	mov	di,string	; di=pointer to string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	dx,di		; dx=string addr; save return value
	mov	bx,count	; max chars to set
	xor	ax,ax		; null byte
	mov	cx,bx
	jcxz	done		; zero length specified

repne	scasb			; find null byte & count bytes in cx
	jne	nonull		; null not found
	inc	cx		; don't want the null

nonull:
	sub	bx,cx		; bx=strlen (not null)
	mov	cx,bx		; cx=strlen (not null)

	mov	di,dx		; restore string pointer
	mov	al,val		; byte value
rep	stosb

done:
	mov	ax,dx		; return value: string addr

if	sizeD
	mov	dx,es		; put segment part of addr in dx
endif

	pop	di
cEnd

% sEnd	CODE_SEG
	end
