	page	,132
	title	strrchr - find last occurence of character in string
;***
;strrchr.asm - find last occurrence of character in string
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strrchr() - find the last occurrence of a given character
;	in a string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strrchr(string, ch) - find last occurrence of ch in string
;
;Purpose:
;	Finds the last occurrence of ch in string.  The terminating
;	null character is used as part of the search.
;
;	Algorithm:
;	char *
;	strrchr (string, ch)
;	      char *string, ch;
;	      {
;	      char *start = string;
;
;	      while (*string++)
;		      ;
;	      while (--string != start && *string != ch)
;		      ;
;	      if (*string == ch)
;		      return(string);
;	      return(NULL);
;	      }
;
;Entry:
;	char *string - string to search in
;	char ch - character to search for
;
;Exit:
;	returns a pointer to the last occurrence of ch in the given
;	string
;	returns NULL if ch does not occurr in the string
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrrchr,<PUBLIC>,<>

else

cProc	strrchr,<PUBLIC>,<>

endif

	parmdp	string
	parmb	chr

cBegin
	push	di

if	sizeD
	les	di,string	; di=pointer to string (es=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,string	; di=pointer to string
endif

	xor	ax,ax		; al=null byte
	mov	cx,-1
repne	scasb			; find the null & count bytes
	not	cx		; cx = byte count (with null)
	dec	di		; di points to terminal null

if	sizeD
	or	al,chr		; al = search byte (note that ax was 0)
	jnz	@F		; not searching for terminal null

;
; special handling is needed if searching for the terminal null character
; since the string may be of maximum length. there are two cases: if the
; string is of normal length, es:di points to the terminal null. otherwise,
; es:di points to the last non-null character of the string.
;
	cmp	al,es:[di]	; es:di point to the null character?
	jne	retsuccess	; no, next character must be the null
	dec	di		; yes, decrement di for return calculation
	jmp	short retsuccess
@@:
else
	mov	al,chr		; al = search byte
endif
	std			; count 'down' on string this time
repne	scasb			; find that byte
	je	retsuccess	; byte found, go return pointer to it

	xor	ax,ax		; no, return NULL

if	sizeD
	mov	dx,ax		; make dx NULL too
endif

	jmp	short toend	; do return sequence

retsuccess:
	lea	ax,[di + 1]	; ax = pointer to byte

if	sizeD
	mov	dx,es		; segment part of addr
endif

toend:
	cld
	pop	di
cEnd

% sEnd	CODE_SEG
	end
