	page	,132
	title	strset - set all characters of string to character
;***
;strset.asm - sets all charcaters of string to given character
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strset() - sets all of the characters in a string (except
;	the '\0') equal to a given character.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *_strset(string, val) - sets all of string to val
;
;Purpose:
;	Sets all of characters in string (except the terminating '/0'
;	character) equal to val.
;
;	Algorithm:
;	char *
;	_strset (string, val)
;	      char *string;
;	      char val;
;	      {
;	      char *start = string;
;
;	      while (*string)
;		      *string++ = val;
;	      return(start);
;	      }
;
;Entry:
;	char *string - string to modify
;	char val - value to fill string with
;
;Exit:
;	returns string -- now filled with val's
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrset,<PUBLIC>,<>

else

cProc	_strset,<PUBLIC>,<>

endif

	parmdp	string
	parmb	val

cBegin
	push	di

if	sizeD
	les	di,string	; di=pointer to string (es=segment part)
else
	mov	di,string	; di=pointer to string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	dx,di		; dx=string addr; save return value
	xor	ax,ax		; ax=0
	mov	cx,-1
repne	scasb			; scan string & count bytes
	not	cx		; cx=strlen+1

if	sizeD
	jne	@F		; if didn't get to null, length must be 0xffff
	dec	cx
@@:				; cx=strlen
else
	dec	cx		; cx=strlen
endif

	mov	al,val
	mov	di,dx		; di=string addr
rep	stosb
	mov	ax,dx		; return value: string addr

if	sizeD
	mov	dx,es		; put segment part of addr in dx
endif

	pop	di
cEnd

% sEnd	CODE_SEG
	end
