	page	,132
	title	strspn - search for init substring of chars from control str
;***
;strspn.asm - find length of initial substring of chars from a control string
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strspn() - finds the length of the initial substring of
;	a string consisting entirely of characters from a control string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

;
;	MASKOFF - Translates a byte value into a bit-mask + byte offset
;
;		INPUT:	AX = byte value (Note: AH *MUST* == 0)
;		OUTPUT: AX = bit mask (2 ** N, where 0 <= N <= 7)
;			DI = byte offset (0 <= BX <= 31)
;		USES:	CX (always set to 3)
;
MaskOff MACRO
	mov	di,ax
	mov	cx,ax		; DI, CX = the next LIST byte
	mov	al,1
	and	cl,7		; just the low 3 bits
	shl	al,cl		; AX = byte mask for the bit table
	mov	cl,3
	shr	di,cl		; DI = byte offset the bit table
	ENDM

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int strspn(string, control) - find init substring of control chars
;
;Purpose:
;	Finds the index of the first character in string that does belong
;	to the set of characters specified by control.	This is
;	equivalent to the length of the initial substring of string that
;	consists entirely of characters from control.  The '\0' character
;	that terminates control is not considered in the matching process.
;
;	Algorithm:
;	int
;	strspn (string, control)
;		unsigned char *string, *control;
;	{
;		unsigned char map[32];
;		int count;
;
;		for (count = 0; count < 32; count++)
;			map[count] = 0;
;		while (*control)
;		{
;			map[*control >> 3] |= (1 << (*control & 7));
;			control++;
;		}
;		if (*string)
;		{
;			while (map[*string >> 3] & (1 << (*string & 7)))
;			{
;				count++;
;				string++;
;			}
;			return(count);
;		}
;		return(0);
;	}
;
;Entry:
;	char *string - string to search
;	char *control - string containing characters not to search for
;
;Exit:
;	returns index of first char in string not in control
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrspn,<PUBLIC>,<si,di>

else

cProc	strspn,<PUBLIC>,<si,di>

endif

	parmDP	string
	parmDP	control

	localV	table,32	; table of flags, one per 8-bit character
cBegin

if sizeD
	push	ds
	lds	si,control
	assumes ds,nothing
else
	mov	si,control
endif
	mov	ax,ss
	mov	es,ax
	assumes es,nothing

	mov	cx,16		; 16 words * 16 bits/word => 256 bits
	xor	ax,ax
	lea	di,table
	rep	stosw		; zero out 256-bit table

list_next:
	lodsb
	or	al,al
	jz	list_done
;---
	MaskOff
;---
	or	byte ptr [table+di],al
	jmp	list_next

list_done:
if sizeD
	lds	si,string
	assumes ds,nothing
else
	mov	si,string
endif

	mov	bx,-1
dst_next:
	inc	bx
	lodsb
	and	ax,00FFH	; "mov ah,0" ; "or al,al"
	jz	dst_done
;---
	MaskOff
;---
	and	al,[table+di]
	jnz	dst_next

dst_done:
	xchg	ax,bx		; BX is the index of the mismatching character

if sizeD
	pop	ds
endif

cEnd				; Must NOT use <nogen>

% sEnd	CODE_SEG

	end
