	page	,132
	title	strstr - search for one string inside another
;***
;strstr.asm - search for one string inside another
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strstr() - search for one string inside another
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;char *strstr(string1, string2) - search for string2 in string1
;
;Purpose:
;	finds the first occurrence of string2 in string1
;
;Entry:
;	char *string1 - string to search in
;	char *string2 - string to search for
;
;Exit:
;	returns a pointer to the first occurrence of string2 in
;	string1, or NULL if string2 does not occur in string1
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrstr,<PUBLIC>,<si,di>

else

cProc	strstr,<PUBLIC>,<si,di>

endif

	parmDP	dst		; string1 = where to look
	parmDP	src		; string2 = what to look for

	localW	srclen

cBegin

if	sizeD
	push	ds		; Preserve DS
	les	di,(src)
	push	es
	pop	ds		; save (src) segment in DS
else
	push	ds
	pop	es		; ES = DS = DGROUP
	mov	di,(src)
endif

	xor	ax,ax		; Scan for null at end of (src)
	mov	cx,-1

	repnz	scasb
	not	cx

if	sizeD
	jne	@F		; if didn't find null, strlen must be 0xffff
	dec	cx
@@:				; CX = strlen(src)
else
	dec	cx		; CX = strlen(src)
endif

	jcxz	empty_src	; src == "" ?
	dec	cx		; CX = strlen(src)-1

	mov	(srclen),cx

if	sizeD
	les	di,(dst)
else
	mov	di,(dst)
endif
	mov	bx,di		; BX will keep the current offset into (dst)

	xor	ax,ax		; Scan for null at end of (dst)
	mov	cx,-1

	repnz	scasb
	not	cx

if	sizeD
	jne	@F		; if didn't find null, strlen must be 0xffff
	dec	cx
@@:				; CX = strlen(src)
else
	dec	cx		; CX = strlen(src)
endif

	mov	dx,cx		; Save strlen(dst) in DX

	sub	dx,(srclen)	; DX = strlen(dst) - (strlen(src)-1)
	jbe	not_found	; strlen(dst) <= (strlen(src)-1)
				; target is longer than source?
	mov	di,bx		; restore ES:DI = (dst)

findnext:
	mov	si,word ptr (src)
	lodsb			; Get the first byte of the source
	mov	di,bx		; restore position in source
	mov	cx,dx		; count of possible starting bytes in src
;
;	CX, DX = number of bytes left in source where target can still fit
;	ES:DI, ES:BX = current position in (dst)
;	DS:SI = (src) + 1
;	AL = *(src)
;
	repne	scasb		; find next occurrence of *(target) in dst
	jne	not_found	; out of string -- return NULL

	mov	dx,cx		; update count of acceptable bytes left in dst
	mov	bx,di		; save current offset in dst

	mov	cx,(srclen)
	jcxz	match		; single character src string?
	repe	cmpsb

	jne	findnext
;
; Match!  Return DS:(BX-1)
;
match:
	lea	ax,[bx-1]
if	sizeD
	mov	dx,es
endif
	jmp	short	retval

empty_src:	; empty src string, return dst (ANSI mandated)
if sizeD
	les	ax, (dst)
	mov	dx, es		; dx:ax = dest
else
	mov	ax, (dst)	; ax = dest
endif
	jmp	short retval	; return

not_found:
	xor	ax,ax
if	sizeD
	cwd
endif

retval:
if	sizeD
	pop	ds		; Restore DS
endif

	cEnd

% sEnd	CODE_SEG

	end
