	page	,132
	title	strtok - tokenize a string
;***
;strtok.asm - tokenize a string with given delimiters
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines strtok() - breaks string into series of token
;	via repeated calls.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	.list
	include os2dll.inc

;
; The way this code is structured, if _LOAD_DGROUP is defined, MTHREAD better
; be defined, too.
; 	- untrue. JWM
;
;ifdef _LOAD_DGROUP
;  ifndef MTHREAD
;  %OUT *** ERROR:  Unsupported build switch combination ****
;  .ERR
;  endif
;endif

;
;	MASKOFF - Translates a byte value into a bit-mask + byte offset
;
;		INPUT:	AX = byte value (Note: AH *MUST* == 0)
;		OUTPUT: AX = bit mask (2 ** N, where 0 <= N <= 7)
;			DI = byte offset (0 <= DI <= 31)
;
;		USES:	BX = index into the array char far *token[MAXTHREADID]
;			CX (always set to 3)
;			DX = saved value of DI
;			ES = saved value of DS
;
MaskOff MACRO
	mov	di,ax
	mov	cx,ax		; DI, CX = the next LIST byte
	mov	al,1
	and	cl,7		; just the low 3 bits
	shl	al,cl		; AX = byte mask for the bit table
	mov	cl,3
	shr	di,cl		; DI = byte offset the bit table
	ENDM

sBegin	data
	assumes ds,data

	staticDP token,0
sEnd


sBegin	code

	assumes cs,code

page
;***
;char *strtok(string, control) - tokenize string with delimiter in control
;
;Purpose:
;	strtok considers the string to consist of a sequence of zero or more
;	text tokens separated by spans of one or more control chars. the first
;	call, with string specified, returns a pointer to the first char of the
;	first token, and will write a null char into string immediately
;	following the returned token. subsequent calls with zero for the first
;	argument (string) will work thru the string until no tokens remain. the
;	control string may be different from call to call. when no tokens remain
;	in string a NULL pointer is returned. remember the control chars with a
;	bit map, one bit per ascii char. the null char is always a control char.
;
;	Algorithm:
;	char *
;	strtok (string, control)
;		unsigned char *string, *control;
;	{
;		unsigned char map[32];
;		int count;
;		static char *nextoken;
;		char *token;
;
;		for (count = 0; count < 32; count++)
;			map[count] = 0;
;		do {
;			map[*control >> 3] |= (1 << (*control & 7));
;		} while (*control++);
;		if (!string)
;			string = nextoken;
;		while (map[*string >> 3] & (1 << (*string & 7)) && *string)
;			string++;
;		token = string;
;		for (;; string++)
;		{
;			if (map[*string >> 3] & (1 << (*string & 7)))
;			{
;				if (!*string && string == token)
;					return(NULL);
;				if (*string)
;					*string++ = '\0';
;				nextoken = string;
;				return(token);
;			}
;		}
;	}
;
;Entry:
;	char *string - string to tokenize, or NULL to get next token
;	char *control - string of characters to use as delimiters
;
;Exit:
;	returns pointer to first token in string, or if string
;	was NULL, to next token
;	returns NULL when no more tokens remain.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fstrtok,<PUBLIC>,<si,di>

else

cProc	strtok,<PUBLIC>,<si,di>

endif

	parmDP	string
	parmDP	control

	localV	table,32	; table of flags, one per 8-bit character

cBegin


	push	ss
	pop	es
	assumes es,nothing

	mov	cx,16		; 16 words * 16 bits/word => 256 bits
	xor	ax,ax
	lea	di,table
	rep	stosw		; zero out 256-bit table

;
; Set up es:bx to point to the token pointer in all cases.
; For non-mthread code, this means that es=ds.
;
if sizeD
	push	ds
	pop	es		; Preserve DS (DGROUP) in ES
	assumes es,data

	lds	si,control	; ds:si = control
	assumes ds,nothing

else ; not sizeD
	mov	si,control	; si = control
endif

list_next:
	lodsb
	or	al,al
	jz	list_done
;---
	MaskOff
;---
	or	[table+di],al
	jmp	list_next

list_done:

if sizeD
	lds	si,string
	assumes ds,nothing

	mov	ax,ds
	or	ax,si		; DS:SI == 0:0 ?
	jnz	dst_next
	lds	si,token

else	; not sizeD
	mov	si,string
	or	si,si
	jnz	dst_next
	mov	si,token
endif

dst_next:
	lodsb
	and	ax,00FFH	; "mov ah,0" ; "or al,al"
	jnz	return_nonnull

	dec	si		; null byte after 0 or more delimiters
	mov	word ptr [token],si
if sizeD
	mov	word ptr [token+2],ds
	mov	ds,ax		; guaranteed to be zero
endif	;sizeD
	jmp	short clean_up

return_nonnull:
;---
	MaskOff
;---
	and	al,[table+di]
	jnz	dst_next

dst_done:
	lea	ax,[si-1]	; point ax at the beginning of the string

	mov	word ptr [token],ax
if sizeD
	mov	word ptr [token+2],ds
endif	;sizeD

find_end:
	lodsb
	and	ax,00FFH	; "mov ah,0" ; "or al,al"
	jnz	not_last	; very last token in string

	lea	ax,[si-1]	; point at terminating null at end of token
	jmp	short last_token
not_last:
;---
	MaskOff
;---
	and	al,[table+di]
	jz	find_end

	mov	ds:[si-1],ah	; null-terminate string
	xchg	ax,si

last_token:
	xchg	ax,word ptr [token]

clean_up:

if sizeD
	mov	dx,ds		; return segment part of address in DX

	push	es
	pop	ds		; Restore DS
	assumes ds,data
endif

cEnd				; Must NOT use <nogen>

sEnd

	end
