/***
*strxfrm.c - Transform a string using locale information
*
*   Copyright (c) 1988-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Transform a string using the locale information as set by
*   LC_COLLATE.
*
*******************************************************************************/

#include <string.h>



/***
*size_t strxfrm() - Transform a string using locale information
*
*Purpose:
*   Transform the string pointer to by _string2 and place the
*   resulting string into the array pointer to by _string1.
*   No more than _count characters are place into the
*   resulting string (including the null).
*
*   The transformation is such that if strcmp() is applied to
*   the two transformed strings, the return value is equal to
*   the result of strcoll() applied to the two original strings.
*   Thus, the conversion must take the locale LC_COLLATE info
*   into account.
*   [ANSI]
*
*   The value of the following expression is the size of the array
*   needed to hold the transformation of the source string:
*
*       1 + strxfrm(NULL,string,0)
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*   Thus, strxfrm() simply resolves to strncpy()/strlen().
*
*Entry:
*   char *_string1       = result string
*   const char *_string2 = source string
*   size_t _count        = max chars to move
*
*   [If _count is 0, _string1 is permitted to by NULL.]
*
*Exit:
*   Length of the transformed string (not including the terminating
*   null).  If the value returned is >= _count, the contents of the
*   _string1 array are indeterminate.
*
*Exceptions:
*
*******************************************************************************/

size_t _cdecl  strxfrm (_string1, _string2, _count)
char *_string1;
const char *_string2;
size_t _count;
{
    strncpy(_string1, _string2, _count);
    return(strlen(_string2));
}
