	page	,132
	title	wcscat - concatenate (append) one string to another
;***
;wcscat.asm - contains wcscat() routine
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	WCSCAT concatenates (appends) a copy of the source wchar_t string to
;	the end of the destination string, returning the destination string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcscat(dst, src) - concatenate (append) one string to another
;
;Purpose:
;	Concatenates src onto the end of dest.	Assumes enough
;	space in dest.
;
;	Algorithm:
;	wchar_t * wcscat (wchar_t * dst, wchar_t * src)
;	{
;	    wchar_t * cp = dst;
;
;	    while( *cp )
;		    ++cp;	    /* Find end of dst */
;	    while( *cp++ = *src++ )
;		    ;		    /* Copy src to end of dst */
;	    return( dst );
;	}
;
;Entry:
;	wchar_t *dst - string to which "src" is to be appended
;	const wchar_t *src - string to be appended to the end of "dst"
;
;Exit:
;	The address of "dst" in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcscat,<PUBLIC>,<>

else

cProc	wcscat,<PUBLIC>,<>

endif

	parmDP	dst
	parmDP	src

cBegin
	mov	dx,di		; Preserve SI and DI
	mov	bx,si

if	sizeD
	push	ds		; Preserve DS
	les	di,dst		; ES:DI = dst
else
	mov	ax,ds
	mov	es,ax
	mov	di,dst		; ES:DI = dst
endif
	xor	ax,ax
	mov	cx,-1		; find end of dst
	repne	scasw
	lea	si,[di-2]	; ES:SI = dst + wcslen(dst)

if	sizeD
	les	di,src		; ES:DI = src
else
	mov	di,src		; ES:DI = src
endif
	mov	cx,-1		; compute wcslen(src)
	repne	scasw
	not	cx		; CX = wcslen(src) + 1
	sub	di,src		; restore ES:DI = src

if	sizeD
	mov	ax,es
	mov	ds,ax		; DS:DI = src
	mov	es,word ptr (dst+2)
endif
	xchg	di,si		; DS:SI = src, ES:DI = dst+wcslen(dst)

	mov	ax,word ptr (dst) ; ax = offset of dest address (for return)
;
; assume that wchar_t string is word-aligned
;
	rep	movsw		; copy cx words from src to dst+wcslen(dst)
;
; Return the "dst" address in AX/DX:AX
;
done:
	mov	si,bx
	mov	di,dx		; Restore SI and DI

if	sizeD
	pop	ds		;restore ds
	mov	dx,es		;segment part of dest address
endif
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
