	page	,132
	title	wcschr - search wchar_t string for given wide character
;***
;wcschr.asm - search a wchar_t string for a given wide character
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	defines wcschr() - search a wchar_t string for a wide character
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin  CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcschr(string, c) - search a wchar_t string for a wide character
;
;Purpose:
;	Searches a wchar_t string for a given wide character, which may be the
;	null character 'W\0'.
;
;	Algorithm:
;	wchar_t *
;	wcschr (string, ch)
;	      wchar_t *string, ch;
;	      {
;	      while (*string && *string != ch)
;		      string++;
;	      if (*string == ch)
;		      return(string);
;	      return((wchar_t *)0);
;	      }
;
;Entry:
;	wchar_t *string - string to search in
;	wchar_t c - wide character to search for
;
;Exit:
;	returns pointer to the first occurence of c in string
;	returns NULL if c does not occur in string
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcschr,<PUBLIC>,<>

else

cProc	wcschr,<PUBLIC>,<>

endif

	parmdp	string
	parmW	chr

cBegin
	mov	dx,di		; save di

if	sizeD
	les	di,string	; di=pointer to string (es=segment part)
else
	mov	di,string	; di=pointer to string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	bx,di		; bx saves string pointer
	xor	ax,ax		; null word to search for
	mov	cx,-1		; count words negatively in cx
repne	scasw			; find string length by scanning for null
	inc	cx		; cx=-count (including null)
	neg	cx		; cx=wcslen+1
	mov	ax,chr		; al=word to search for
	mov	di,bx		; restore from saved string pointer
repne	scasw			; find that word (if it exists)!
				; di points two past word which stopped scan
	sub	di,2		; di points to word which stopped scan

if	sizeD
	cmp	es:[di],ax	; take one last look to be sure
else
	cmp	[di],ax 	; take one last look to be sure
endif

	je	retdi		; return di if it matches

	xor	di,di		; no match, so return NULL

if	sizeD
	mov	es,di		; seg part is null too
endif

retdi:
	xchg	ax,dx		; ax = old di value; dx = seg part of ret val
	xchg	ax,di		; ret value: pointer to matching word

if	sizeD
	mov	dx,es		; seg part
endif

cEnd

% sEnd	CODE_SEG
	end
