/***
*wcscoll.c - Locale-dependent collation of wchar_t strings
*
*   Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
*
*Purpose:
*   Compare two wchar_t strings using the locale LC_COLLATE information.
*
*******************************************************************************/

#include <string.h>
#include <locale.h>



/***
*int wcscoll() - Collate strings in locale-dependent manner
*
*Purpose:
*   Compare two wchar_t strings using the locale LC_COLLATE information.
*
*   NOTE:  Currently, the C libraries support the "C" locale only.
*   Thus, wcscoll() simply resolves to wcscmp().
*Entry:
*   const wchar_t *s1 = pointer to the first string
*   const wchar_t *s2 = pointer to the second string
*
*Exit:
*   Less than 0    = first string less than second string
*   0          = strings are equal
*   Greater than 0 = first string greater than second string
*
*Exceptions:
*
*******************************************************************************/

int _cdecl  wcscoll
    (
    const wchar_t *_wcs1,
    const wchar_t *_wcs2
    )
{
    return(wcscmp(_wcs1,_wcs2));
}
