	page	,132
	title	wcscpy - copy one wchar_t string over another
;***
;wcscpy.asm - contains wcscpy() routine, copy wchar_t strings
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All Rights Reserved.
;
;Purpose:
;	WCSCPY copies one wchar_t string to another, overwriting the previous
;	contents of the destination wchar_t string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcscpy(dst, src) - copy one wchar_t string over another
;
;Purpose:
;	Copies the wchar_t string src into the spot specified by
;	dest; assumes enough room.
;
;	Algorithm:
;	wchar_t * wcscpy (wchar_t * dst, wchar_t * src)
;	{
;	    wchar_t * cp = dst;
;
;	    while( *cp++ = *src++ )
;		    ;		    /* Copy src over dst */
;	    return( dst );
;	}
;
;Entry:
;	wchar_t * dst - wchar_t string over which "src" is to be copied
;	const wchar_t * src - wchar_t string to be copied over "dst"
;
;Exit:
;	The address of "dst" in AX/DX:AX
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcscpy,<PUBLIC>,<>

else

cProc	wcscpy,<PUBLIC>,<>

endif
	parmDP	dst
	parmDP	src

cBegin
	mov	dx,di		; Preserve SI and DI
	mov	bx,si

if	sizeD
	push	ds		; Preserve DS
	lds	si,src		; DS:SI = src
else
	mov	si,src		; DS:SI = src
endif
	mov	di,si		; set ES:DI to DS:SI for first part
	mov	ax,ds
	mov	es,ax

	xor	ax,ax
	mov	cx,-1		; find length of src
	repne	scasw
	not	cx		; CX=wcslen(src)+1

if	sizeD
	les	di,dst		; ES:DI = dst
	mov	ax,di		; AX = return value (offset)
else
	mov	ax,dst		; AX = return value (offset)
	mov	di,ax		; ES:DI = dst
endif

;
; assume wchar_t strings are word-aligned
;
	rep	movsw		; CF set if one byte left over
;
; Return the "dst" address in AX/DX:AX
;
done:
	mov	si,bx
	mov	di,dx		; Restore SI and DI

if	sizeD
	pop	ds		;restore ds
	mov	dx,es		;segment part of dest address
endif
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
