	page	,132
	title	wcscspn - find init substring of chars not in other wc string
;***
;wcscspn.asm - find init substring of wchar_t not in other wchar_t string
;
;	Copyright (c) 1985-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcscspn() - find init substring of chars not in other wc string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int wcscspn(wcs, control) - search for init substring w/o control chars
;
;Purpose:
;	returns the index of the first character in wchar_t string that belongs
;	to the set of characters specified by control.	This is equivalent
;	to the length of the initial substring of string
;	composed entirely of characters not in control.  Null chars not
;	considered.
;
;	Algorithm:  (not currently used for wcscspn)
;	int
;	strcspn (string, control)
;		unsigned char *string, *control;
;	{
;		unsigned char map[32];
;		int count;
;
;		for (count = 0; count < 32; count++)
;			map[count] = 0;
;		while (*control)
;		{
;			map[*control >> 3] |= (1 << (*control & 7));
;			control++;
;		}
;		map[0] |= 1;
;		while (!(map[*string >> 3] & (1 << (*string & 7))))
;		{
;			count++;
;			string++;
;		}
;		return(count);
;	}
;
;Entry:
;	wchar_t *wcs - wide character string to search
;	wchar_t *control - set of wide characters not allowed in init substring
;
;Exit:
;	returns the index of the first char in wcs
;	that is in the set of characters specified by control.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcscspn,<PUBLIC>,<si,di>

else

cProc	wcscspn,<PUBLIC>,<si,di>

endif

	parmDP	wcs
	parmDP	control

;	localV	table,32	; table of flags, one per 8-bit character
cBegin

if sizeD
	push	ds
	assumes ds,nothing
	lds	si,wcs

	les	di,control
	assumes es,nothing
else
	mov	si,wcs
	mov	di,control
endif

	mov	dx,di
	xor	ax,ax

	mov	cx,-1
	repnz	scasw		; find end of wcs
	; consider: error if not found
	inc	cx
	neg	cx		; cx = wcslen(control) + 1
	mov	bx,cx


	lodsw			; read each wchar_t
list_loop:
	and	ax,ax		; until either we reach the end
	jz	list_done

	mov	cx,bx
	mov	di,dx
	repnz	scasw			; or until a match is found
	lodsw				; read each wchar_t (inc SI)
	jnz	list_loop		; loop if no match

list_done:
	stc				; return(si-wcs-1)
	sbb	si,wcs
	mov	ax,si

if sizeD
	pop	ds
endif

cEnd				; Must NOT use <nogen>

% sEnd	CODE_SEG

	end
