	page	,132
	title	wcsdup - duplicate wchar_t string in malloc'd memory
;***
;wcsdup.asm - duplicate a wchar_t string in malloc'd memory
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	wcsdup() - grab new memory, and duplicate the wchar_t string into it.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include model.inc
	.list

;
; wcsDPTR = size of pointer that is supplied to the wchar_t string routines.
; heapDPTR = size of pointer returned from heap call.
;
ifdef	MODELINDEP
    wcsDPTR = 1
    ifdef   NEARMODELINDEP
	heapDPTR = 0
    else
	heapDPTR = 1
    endif
else
    wcsDPTR = sizeD
    heapDPTR = sizeD
endif

;
; external routine declarations
;
ifdef	MODELINDEP
	externFP _fwcslen
	externFP _fwcscpy
else
	externP wcslen
	externP wcscpy
endif

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
	externP     _nmalloc
    else
	externP     _fmalloc
    endif

else ;	MODELINDEP

	externP malloc

endif ; MODELINDEP


sBegin	code

	assumes cs,code
	assumes ds,data

page
;***
;wchar_t *_wcsdup(wcs) - duplicate wchar_t string into malloc'd memory
;
;Purpose:
;	Allocates enough storage via malloc() for a copy of the
;	wchar_t string, copies the string into the new memory, and returns
;	a pointer to it.
;
;	Algorithm:
;	wchar_t *_wcsdup (wchar_t *wcs)
;	{
;	      wchar_t *memory;
;
;	      if (!wcs)
;		      return(NULL);
;	      if (memory = malloc(wcslen(wcs) + 1))
;		      return(wcscpy(memory,wcs));
;	      return(NULL);
;	}
;
;Notes:
;	This source builds 3 objects:
;
;		(1) _wcsdup() - generic model version
;		(2) _fwcsdup() - returns a far pointer
;		(3) _nwcsdup() - returns a near pointer
;
;Entry:
;	wchar_t *wcs - string to copy into new memory
;
;Exit:
;	returns a pointer to the newly allocated storage with the
;	wchar_t string in it.
;	returns NULL if enough memory could not be allocated, or
;	wcs was NULL.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
cProc	_nwcsdup,<PUBLIC,FAR>,<>
    else
cProc	_fwcsdup,<PUBLIC,FAR>,<>
    endif

	parmD	wcs

else ;	MODELINDEP

cProc	_wcsdup,<PUBLIC>,<>

	parmDP	wcs
endif


cBegin
	push	di		; save di

;
; calculate length
;

if	wcsDPTR
	les	di,wcs		; di=pointer to wcs (es=segment part)
	push	es		; push segment part of address
else
	mov	di,wcs		; di=pointer to wcs
endif
	push	di		; stack parameter: wchar_t string pointer

ifdef	MODELINDEP
	call	__fwcslen	; get it's length
else
	call	_wcslen 	; get it's length
endif
				; ax = wchar_t string length
	inc	ax		; need space for null word too
	shl	ax,1		; need bytes, not words, for malloc
	push	ax		; stack parameter: string length (with null)

;
; get the space for duplicate wchar_t string
; tos = 2 x length of wchar_t string
; [source wchar_t string pointer is still on stack, too]

ifdef	MODELINDEP

    ifdef   NEARMODELINDEP
	call	__nmalloc	; ax = near heap space
	mov	dx,ds		; dx:ax = far ptr to space (for _wcscpy)
    else
	call	__fmalloc	; dx:ax = far heap space
    endif

else ;	MODELINDEP

	call	_malloc 	; (dx):ax = heap space

endif

	pop	bx		; burn malloc arg
				; (dx:)ax = heap pointer
if	heapDPTR
	mov	bx,ax		; preserve ax
	or	bx,dx		; dx:ax == NULL ??
	jnz	okay		; jump out if not
else
	or	ax,ax		; ax == NULL ??
	jnz	okay		; jump out if not
endif
	;fall thru		; error - return NULL

if	wcsDPTR
	add	sp,4		; burn wchar_t string arg still on stack
else
	pop	bx		; burn wchar_t string arg still on stack
endif
	jmp	short toend	; error - return NULL

;
; copy source wchar_t string to duplicate string
;

okay:

if	wcsDPTR
	push	dx		; push segment part of dest string to copy to
endif
	push	ax		; stack pointer to dest

ifdef	MODELINDEP
	call	__fwcscpy
	add	sp,8		; always two far pointers
else
	call	_wcscpy 	; duplicate the wchar_t string
	add	sp,dat_addr_sz+dat_addr_sz ; burn 2 parameter pointers
endif

;
; Return pointer is in (dx:)ax	(may be NULL)
;

toend:
	pop	di

cEnd	<nolocals>

sEnd

	end
