	page	,132
	title	wcslen - return the length of a null-terminated wchar_t string
;***
;wcslen.asm - contains wcslen() routine
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	wcslen returns the length of a null-terminated wchar_t string,
;	not including the null word itself.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wcslen - return the length of a null-terminated wchar_t string
;
;Purpose:
;	Finds the length in words of the given wchar_t string, not including
;	the final null wide character.
;
;	Algorithm:
;	int wcslen (const wchar_t * wcs)
;	{
;	    int length = 0;
;
;	    while( *wcs++ )
;		    ++length;
;
;	    return( length );
;	}
;
;Entry:
;	const wchar_t * wcs - wchar_t string whose length is to be computed
;
;Exit:
;	AX = length of the wchar_t string "wcs", excluding the final null word
;
;Uses:
;	BX, CX, DX
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcslen,<PUBLIC>,<>

else

cProc	wcslen,<PUBLIC>,<>

endif

	parmDP	wcs

cBegin
	mov	dx,di		; Preserve DI

if	sizeD
	les	di,wcs		; ES:DI = wcs
else
	mov	ax,ds
	mov	es,ax
	mov	di,wcs		; ES:DI = wcs
endif
	xor	ax,ax		; null word
	mov	cx,-1
	repne	scasw		; scan for null, CX = -(1+wcslen(wcs))
	not	cx
	dec	cx
	xchg	ax,cx		; AX = wcslen(wcs)

	mov	di,dx		; Restore DI
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG
	end
