	page	,132
	title	wcsncat - append n chars of wchar_t string1 to wchar_t string2
;***
;wcsncat.asm - append n chars of wchar_t string to new wchar_t string
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsncat() - appends n wide characters of string onto
;	end of other wchar_t string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcsncat(front, back, count) - append count chars of back onto front
;
;Purpose:
;	Appends at most count wide characters of the string back onto the
;	end of front, and ALWAYS terminates with a wchar_t null character.
;	If count is greater than the length of back, the length of back
;	is used instead.  (Unlike wcsncpy, this routine does not pad out
;	to count wide characters).
;
;	Algorithm:
;	wchar_t *
;	wcsncat (front, back, count)
;		wchar_t *front, *back;
;		unsigned count;
;	{
;		wchar_t *start = front;
;
;		while (*front++)
;			;
;		front--;
;		while (count--)
;			if (!(*front++ = *back++))
;				return(start);
;		*front = L'\0';
;		return(start);
;	}
;
;Entry:
;	wchar_t *front - wchar_t string to append onto
;	wchar_t *back - wchar_t string to append
;	unsigned count - count of max wide characters to append
;
;Exit:
;	returns a pointer to wchar_t string appended onto (front).
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsncat,<PUBLIC>,<>

else

cProc	wcsncat,<PUBLIC>,<>

endif

	parmDP	front
	parmDP	back
	parmW	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,front	; di=pointer to dest (es=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,front	; di=pointer to dest
endif

	mov	dx,di		; save return value in dx
	xor	ax,ax		; search value: null word (assumed zero below!)
	mov	cx,-1		; so won't stop scan
repne	scasw			; find null word
	lea	bx,[di-2]	; bx points to dest null terminator

if	sizeD
	push	es		; save dest seg pointer
	les	di,back 	; di=pointer to source (es=segment part)
else
	mov	di,back 	; di=pointer to source
endif

	mov	si,di		; si=pointer to source (used below)
	mov	cx,count	; count words negatively
repne	scasw			; find null word & get source length
	jne	nonull
	inc	cx		; do NOT count null word in length
nonull:
				; cx=count of difference in bytes in source
				;    with reference (without null)
	sub	cx,(count)	; take the difference of words counted to expected
	neg	cx		; away from expected
	mov	di,bx		; di=pointer to dest null terminator
				; si=pointer to source

if	sizeD
	push	es		; ds points to back
	pop	ds
	pop	es		; restore dest seg pointer
endif

rep	movsw			; concatenate the wchar_t strings
				; WARNING: AX must be zero at this point!
	stosw			; attach null byte
	xchg	ax,dx		; return value: dest addr

if	sizeD
	mov	dx,es		; segment part of addr
	pop	ds		; restore ds
endif
	pop	si
	pop	di
	pop	bp
	ret
cEnd	<nogen>

% sEnd	CODE_SEG

	end
