	page	,132
	title	wcsncmp - compare first n wide chars of two wchar_t strings
;***
;wcsncmp.asm - compare first n wide characters of two wchar_t strings
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsncmp() - compare first n wide chars of two wchar_t strings
;	for lexical order.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;int wcsncmp(first, last, count) - compare first count wide chars of strings
;
;Purpose:
;	Compares two wchar_t strings for lexical order.  The comparison stops
;	after: (1) a difference between the strings is found, (2) the end
;	of the strings is reached, or (3) count wide characters have been
;	compared.
;
;	Algorithm:
;	int
;	wcsncmp (first, last, count)
;	      wchar_t *first, *last;
;	      unsigned count;
;	      {
;	      if (!count)
;		      return(0);
;	      while (--count && *first && *first == *last)
;		      {
;		      first++;
;		      last++;
;		      }
;	      return(*first - *last);
;	      }
;
;Entry:
;	wchar_t *first, *last - wchar_t strings to compare
;	unsigned count - maximum number of wide characters to compare
;
;Exit:
;	returns <0 if first < last
;	returns 0 if first == last
;	returns >0 if first > last
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsncmp,<PUBLIC>,<>

else

cProc	wcsncmp,<PUBLIC>,<>

endif

	parmdp	first
	parmdp	last
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
else
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	cx,count	; cx=max number of words to compare
	jcxz	toend		; it's as if strings are equal

	mov	bx,cx		; bx saves count

if	sizeD
	les	di,first	; di=first pointer (es=segment part)
else
	mov	di,first	; di=first pointer
endif

	mov	si,di		; si saves first pointer
	xor	ax,ax		; ax=0
repne	scasw			; count words
	neg	cx		; cx=count - wcslen
	add	cx,bx		; wcslen + count - wcslen

okay:
	mov	di,si		; restore first pointer

if	sizeD
	lds	si,last 	; si=last pointer (ds=segment part)
else
	mov	si,last 	; si=last pointer
endif

repe	cmpsw			; compare wchar_t strings
	mov	cx,[si-2]

if	sizeD
	sub	cx,es:[di-2]	; last-first
else
	sub	cx,[di-2]	; last-first
endif
	je	toend		; cx = 0 if equal

	mov	cx,1
	jb	toend		; first string is bigger: return 1
	neg	cx		; last string is bigger: return -1

toend:
	xchg	ax,cx		; (mov ax,cx) return value

if	sizeD
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
