	page	,132
	title	wcsncpy - copy at most n characters of wchar_t string
;***
;wcsncpy.asm - copy at most n characters of wchar_t string
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsncpy() - copy at most n characters of wchar_t string
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcsncpy(dest, source, count) - copy at most n characters
;
;Purpose:
;	Copies count characters from the source wchar_t string to the
;	destination.  If count is less than the length of source,
;	NO NULL CHARACTER is put onto the end of the copied wchar_t string.
;	If count is greater than the length of sources, dest is padded
;	with null characters to length count.
;
;	Algorithm:
;	wchar_t *
;	wcsncpy (dest, source, count)
;	      char *dest, *source;
;	      unsigned count;
;	      {
;	      wchar_t *start = dest;
;
;	      while (count && (*dest++ = *source++))
;		      count--;
;	      if (count)
;		      while (--count)
;			      *dest++ = '\0';
;	      return(start);
;	      }
;
;Entry:
;	wchar_t *dest - pointer to spot to copy source, enough space
;	is assumed.
;	wchar_t *source - source wchar_t string for copy
;	unsigned count - wide characters to copy
;
;Exit:
;	returns dest, with the wide character copied there.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsncpy,<PUBLIC>,<>

else

cProc	wcsncpy,<PUBLIC>,<>

endif

	parmdp	dest
	parmdp	sorc
	parmw	count

cBegin
	push	di
	push	si

if	sizeD
	push	ds		; save ds
	les	di,dest 	; di=pointer to dest (es=segment part)
	lds	si,sorc 	; si=pointer to source (ds=segment part)
else
	push	ds		; fix es for small/middle model
	pop	es
	mov	di,dest 	; di=pointer to dest
	mov	si,sorc 	; si=pointer to source
endif
	mov	bx,di		; bx saves dest pointer
	mov	cx,count	; get the max wchar_t count
	jcxz	toend		; don't do loop if nothing to move

lupe:
	lodsw			; get word into ax and kick si
	or	ax,ax		; see if we just moved a null
	jz	outlupe 	; end of string

	stosw			; store word from ax and kick di
	loop	lupe		; dec cx & jmp to lupe if nonzero
				; else drop out
outlupe:
	xor	ax,ax		; null word to store
rep	stosw			; store null for all cx>0

toend:
	xchg	ax,bx		; return value: dest addr

if	sizeD
	mov	dx,es		; segment part of addr
	pop	ds		; restore ds
endif

	pop	si
	pop	di
cEnd

% sEnd	CODE_SEG
	end
