	page	,132
	title	wcsnset - set first n wide characters to one wide char.
;***
;wcsnset.asm - set first n wide characters to single wide character
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcsnset() - sets at most the first n characters of a wchar_t
;	string to a given wide character.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *_wcsnset(wcs, val, count) - set at most count wide characters to val
;
;Purpose:
;	Sets the first count characters of wcs to the wide character value.
;	If the length of wchar_t string is less than count, the length of
;	wcs is used in place of n.
;
;	Algorithm:
;	wchar_t *
;	_wcsnset (wcs, val, count)
;	      wchar_t *wcs,val;
;	      unsigned int count;
;	      {
;	      wchar_t *start = wcs;
;
;	      while (count-- && *wcs)
;		      *wcs++ = val;
;	      return(start);
;	      }
;
;Entry:
;	wchar_t *wcs - string to set wide characters in
;	wchar_t val - character to fill with
;	unsigned count - count of wide characters to fill
;
;Exit:
;	returns wcs, now filled with count copies of val.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcsnset,<PUBLIC>,<>

else

cProc	_wcsnset,<PUBLIC>,<>

endif

	parmdp	wcs
	parmw	val
	parmw	count

cBegin
	push	di

if	sizeD
	les	di,wcs		; di=pointer to wchar_t string (es=segment part)
else
	mov	di,wcs		; di=pointer to wchar_t string
	push	ds		; fix es for small/middle model
	pop	es
endif

	mov	dx,di		; dx=wchar_t string addr; save return value
	mov	bx,count	; max wide chars to set
	xor	ax,ax		; null word
	mov	cx,bx
	jcxz	done		; zero length specified

repne	scasw			; find null word & count words in cx
	jne	nonull		; null not found
	inc	cx		; don't want the null

nonull:
	sub	bx,cx		; bx=wcslen (not null)
	mov	cx,bx		; cx=wcslen (not null)

	mov	di,dx		; restore wchar_t string pointer
	mov	ax,val		; word value
rep	stosw

done:
	mov	ax,dx		; return value: wchar_t string addr

if	sizeD
	mov	dx,es		; put segment part of addr in dx
endif

	pop	di
cEnd

% sEnd	CODE_SEG
	end
