	page	,132
	title	wcspbrk - find first char from control in a wchar_t string
;***
;wcspbrk.asm - find first wide char from control in a wchar_t string
;
;	Copyright (c) 1990-1992, Microsoft Corporation.  All rights reserved.
;
;Purpose:
;	defines wcspbrk() - scans a wchar_t string until finding any wide character
;	from a wchar_t control string.
;
;*******************************************************************************

	.xlist
	include version.inc
	include cmacros.inc
	include defsegs.inc
	.list

;******************************************************************************
;
; SKIP macro -- Skip execution of the next "n" bytes. Eats them up in a
; one-byte register compare instruction. Needless to say, flags are lost.
;

SKIP	MACRO	LEN
if	len EQ 1		;;if length==1
	db	03Ch		;;cmp al,...
endif
if	len EQ 2		;;else if length==2
	db	03Dh		;;cmp ax,...
endif
if	len GT 2		;;else
	.ERR	<SKIP MACRO: Illegal SKIP length: LEN> ;;Cause an error
endif
	ENDM

; code for model-independent version for llibccrt goes into _RTEXT segment

ifdef	_LOAD_DGROUP
ifdef	MODELINDEP
	CrtDefSegs <rcode>
	CODE_SEG  equ	<rcode>
	CS_ASSUME equ	<_RTEXT>	; assumes macro won't handle rcode
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif
else
	CODE_SEG  equ	<code>
	CS_ASSUME equ	<code>
endif

% sBegin CODE_SEG

%	assumes cs,CS_ASSUME
	assumes ds,data

page
;***
;wchar_t *wcspbrk(wcs, control) - scans string for a wide character from control
;
;Purpose:
;	Finds the first occurence in wcs of any wide character from
;	the control wcs.
;
;	Algorithm:
;	wchar_t *
;	wcspbrk (wcs, control)
;		unsigned wchar_t *wcs, *control;
;	{
;UNDONE:
;		unsigned wchar_t map[32];
;		int count;
;
;		for (count = 0; count < 32; count++)
;			map[count] = 0;
;		while (*control)
;		{
;			map[*control >> 3] |= (1 << (*control & 7));
;			control++;
;		}
;		while (*wcs)
;		{
;			if (map[*wcs >> 3] & (1 << (*wcs & 7)))
;				return(wcs);
;			wcs++;
;		}
;		return(NULL);
;	}
;
;Entry:
;	wchar_t *wcs - string to search in
;	wchar_t *control - string containing wide characters to search for
;
;Exit:
;	returns a pointer to the first wide character from control found
;	in wcs.
;	returns NULL if wcs and control have no wide characters in common.
;
;Uses:
;
;Exceptions:
;
;*******************************************************************************

ifdef	MODELINDEP

cProc	_fwcspbrk,<PUBLIC>,<si,di>

else

cProc	wcspbrk,<PUBLIC>,<si,di>

endif

	parmDP	wcs
	parmDP	control
cBegin
if sizeD
	push	ds
	assumes ds,nothing
	lds	si,wcs

	les	di,control
	assumes es,nothing
else
	mov	si,wcs
	mov	di,control
endif

	mov	dx,di
	xor	ax,ax

	mov	cx,-1
	repnz	scasw		; find end of wcs
	; consider: error if not found
	inc	cx
	neg	cx		; cx = wcslen(control) + 1
	mov	bx,cx


	lodsw			; read each wchar_t
list_loop:
	and	ax,ax		; until either we reach the end
	jz	list_done

	mov	cx,bx
	mov	di,dx
	repnz	scasw		; or until a match is found
	lodsw			; read each wchar_t (inc SI)
	jnz	list_loop	; loop if no match
if sizeD
	mov	dx,ds		; return segment part of address in DX
endif
	lea	ax,[si-2]	; point AX at the byte in question
	skip	2		; jmp list_exit
list_done:
	xor	dx,dx
list_exit:

if sizeD
	pop	ds
endif

cEnd				; Must NOT use <nogen>

% sEnd	CODE_SEG

	end
